import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface RedshiftSecurityGroupConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name: string;
    /** ingress block */
    readonly ingress: RedshiftSecurityGroupIngress[];
}
export interface RedshiftSecurityGroupIngress {
    readonly cidr?: string;
    readonly securityGroupName?: string;
    readonly securityGroupOwnerId?: string;
}
export declare class RedshiftSecurityGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: RedshiftSecurityGroupConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _ingress;
    get ingress(): RedshiftSecurityGroupIngress[];
    set ingress(value: RedshiftSecurityGroupIngress[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
