import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface RedshiftSubnetGroupConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name: string;
    readonly subnetIds: string[];
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class RedshiftSubnetGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: RedshiftSubnetGroupConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _subnetIds;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
