import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ResourcegroupsGroupConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** resource_query block */
    readonly resourceQuery: ResourcegroupsGroupResourceQuery[];
}
export interface ResourcegroupsGroupResourceQuery {
    readonly query: string;
    readonly type?: string;
}
export declare class ResourcegroupsGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: ResourcegroupsGroupConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _resourceQuery;
    get resourceQuery(): ResourcegroupsGroupResourceQuery[];
    set resourceQuery(value: ResourcegroupsGroupResourceQuery[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
