import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface RouteTableConfig extends TerraformMetaArguments {
    readonly propagatingVgws?: string[];
    readonly route?: RouteTableRoute[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcId: string;
}
export interface RouteTableRoute {
    readonly cidrBlock?: string;
    readonly egressOnlyGatewayId?: string;
    readonly gatewayId?: string;
    readonly instanceId?: string;
    readonly ipv6CidrBlock?: string;
    readonly natGatewayId?: string;
    readonly networkInterfaceId?: string;
    readonly transitGatewayId?: string;
    readonly vpcPeeringConnectionId?: string;
}
export declare class RouteTable extends TerraformResource {
    constructor(scope: Construct, id: string, config: RouteTableConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get ownerId(): string;
    private _propagatingVgws?;
    get propagatingVgws(): string[] | undefined;
    set propagatingVgws(value: string[] | undefined);
    private _route?;
    get route(): RouteTableRoute[] | undefined;
    set route(value: RouteTableRoute[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcId;
    get vpcId(): string;
    set vpcId(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
