import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface RouteConfig extends TerraformMetaArguments {
    readonly destinationCidrBlock?: string;
    readonly destinationIpv6CidrBlock?: string;
    readonly egressOnlyGatewayId?: string;
    readonly gatewayId?: string;
    readonly instanceId?: string;
    readonly natGatewayId?: string;
    readonly networkInterfaceId?: string;
    readonly routeTableId: string;
    readonly transitGatewayId?: string;
    readonly vpcPeeringConnectionId?: string;
    /** timeouts block */
    readonly timeouts?: RouteTimeouts;
}
export interface RouteTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class Route extends TerraformResource {
    constructor(scope: Construct, id: string, config: RouteConfig);
    private _destinationCidrBlock?;
    get destinationCidrBlock(): string | undefined;
    set destinationCidrBlock(value: string | undefined);
    private _destinationIpv6CidrBlock?;
    get destinationIpv6CidrBlock(): string | undefined;
    set destinationIpv6CidrBlock(value: string | undefined);
    get destinationPrefixListId(): string;
    private _egressOnlyGatewayId?;
    get egressOnlyGatewayId(): string | undefined;
    set egressOnlyGatewayId(value: string | undefined);
    private _gatewayId?;
    get gatewayId(): string | undefined;
    set gatewayId(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _instanceId?;
    get instanceId(): string | undefined;
    set instanceId(value: string | undefined);
    get instanceOwnerId(): string;
    private _natGatewayId?;
    get natGatewayId(): string | undefined;
    set natGatewayId(value: string | undefined);
    private _networkInterfaceId?;
    get networkInterfaceId(): string | undefined;
    set networkInterfaceId(value: string | undefined);
    get origin(): string;
    private _routeTableId;
    get routeTableId(): string;
    set routeTableId(value: string);
    get state(): string;
    private _transitGatewayId?;
    get transitGatewayId(): string | undefined;
    set transitGatewayId(value: string | undefined);
    private _vpcPeeringConnectionId?;
    get vpcPeeringConnectionId(): string | undefined;
    set vpcPeeringConnectionId(value: string | undefined);
    private _timeouts?;
    get timeouts(): RouteTimeouts | undefined;
    set timeouts(value: RouteTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
