"use strict";
// https://www.terraform.io/docs/providers/aws/r/route53_health_check.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53HealthCheck = void 0;
const cdktf_1 = require("cdktf");
// Resource
class Route53HealthCheck extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_route53_health_check',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._childHealthThreshold = config.childHealthThreshold;
        this._childHealthchecks = config.childHealthchecks;
        this._cloudwatchAlarmName = config.cloudwatchAlarmName;
        this._cloudwatchAlarmRegion = config.cloudwatchAlarmRegion;
        this._enableSni = config.enableSni;
        this._failureThreshold = config.failureThreshold;
        this._fqdn = config.fqdn;
        this._insufficientDataHealthStatus = config.insufficientDataHealthStatus;
        this._invertHealthcheck = config.invertHealthcheck;
        this._ipAddress = config.ipAddress;
        this._measureLatency = config.measureLatency;
        this._port = config.port;
        this._referenceName = config.referenceName;
        this._regions = config.regions;
        this._requestInterval = config.requestInterval;
        this._resourcePath = config.resourcePath;
        this._searchString = config.searchString;
        this._tags = config.tags;
        this._type = config.type;
    }
    get childHealthThreshold() {
        return this._childHealthThreshold;
    }
    set childHealthThreshold(value) {
        this._childHealthThreshold = value;
    }
    get childHealthchecks() {
        return this._childHealthchecks;
    }
    set childHealthchecks(value) {
        this._childHealthchecks = value;
    }
    get cloudwatchAlarmName() {
        return this._cloudwatchAlarmName;
    }
    set cloudwatchAlarmName(value) {
        this._cloudwatchAlarmName = value;
    }
    get cloudwatchAlarmRegion() {
        return this._cloudwatchAlarmRegion;
    }
    set cloudwatchAlarmRegion(value) {
        this._cloudwatchAlarmRegion = value;
    }
    get enableSni() {
        var _a;
        return (_a = this._enableSni) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('enable_sni');
    }
    set enableSni(value) {
        this._enableSni = value;
    }
    get failureThreshold() {
        return this._failureThreshold;
    }
    set failureThreshold(value) {
        this._failureThreshold = value;
    }
    get fqdn() {
        return this._fqdn;
    }
    set fqdn(value) {
        this._fqdn = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get insufficientDataHealthStatus() {
        return this._insufficientDataHealthStatus;
    }
    set insufficientDataHealthStatus(value) {
        this._insufficientDataHealthStatus = value;
    }
    get invertHealthcheck() {
        return this._invertHealthcheck;
    }
    set invertHealthcheck(value) {
        this._invertHealthcheck = value;
    }
    get ipAddress() {
        return this._ipAddress;
    }
    set ipAddress(value) {
        this._ipAddress = value;
    }
    get measureLatency() {
        return this._measureLatency;
    }
    set measureLatency(value) {
        this._measureLatency = value;
    }
    get port() {
        return this._port;
    }
    set port(value) {
        this._port = value;
    }
    get referenceName() {
        return this._referenceName;
    }
    set referenceName(value) {
        this._referenceName = value;
    }
    get regions() {
        return this._regions;
    }
    set regions(value) {
        this._regions = value;
    }
    get requestInterval() {
        return this._requestInterval;
    }
    set requestInterval(value) {
        this._requestInterval = value;
    }
    get resourcePath() {
        return this._resourcePath;
    }
    set resourcePath(value) {
        this._resourcePath = value;
    }
    get searchString() {
        return this._searchString;
    }
    set searchString(value) {
        this._searchString = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get type() {
        return this._type;
    }
    set type(value) {
        this._type = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            child_health_threshold: this._childHealthThreshold,
            child_healthchecks: this._childHealthchecks,
            cloudwatch_alarm_name: this._cloudwatchAlarmName,
            cloudwatch_alarm_region: this._cloudwatchAlarmRegion,
            enable_sni: this._enableSni,
            failure_threshold: this._failureThreshold,
            fqdn: this._fqdn,
            insufficient_data_health_status: this._insufficientDataHealthStatus,
            invert_healthcheck: this._invertHealthcheck,
            ip_address: this._ipAddress,
            measure_latency: this._measureLatency,
            port: this._port,
            reference_name: this._referenceName,
            regions: this._regions,
            request_interval: this._requestInterval,
            resource_path: this._resourcePath,
            search_string: this._searchString,
            tags: this._tags,
            type: this._type,
        };
    }
}
exports.Route53HealthCheck = Route53HealthCheck;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm91dGU1My1oZWFsdGgtY2hlY2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcm91dGU1My1oZWFsdGgtY2hlY2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLDBFQUEwRTtBQUMxRSwyQ0FBMkM7OztBQXVHM0MsaUNBQTBDO0FBMkIxQyxXQUFXO0FBRVgsTUFBYSxrQkFBbUIsU0FBUSx5QkFBaUI7SUFFdkQsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjO0lBRWQsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsTUFBZ0M7UUFDL0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSwwQkFBMEI7WUFDakQsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxLQUFLO2FBQ3BCO1lBQ0QsUUFBUSxFQUFFLE1BQU0sQ0FBQyxRQUFRO1lBQ3pCLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixLQUFLLEVBQUUsTUFBTSxDQUFDLEtBQUs7WUFDbkIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1NBQzVCLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxxQkFBcUIsR0FBRyxNQUFNLENBQUMsb0JBQW9CLENBQUM7UUFDekQsSUFBSSxDQUFDLGtCQUFrQixHQUFHLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQztRQUNuRCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsTUFBTSxDQUFDLG1CQUFtQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxzQkFBc0IsR0FBRyxNQUFNLENBQUMscUJBQXFCLENBQUM7UUFDM0QsSUFBSSxDQUFDLFVBQVUsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO1FBQ25DLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxNQUFNLENBQUMsZ0JBQWdCLENBQUM7UUFDakQsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyw2QkFBNkIsR0FBRyxNQUFNLENBQUMsNEJBQTRCLENBQUM7UUFDekUsSUFBSSxDQUFDLGtCQUFrQixHQUFHLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQztRQUNuRCxJQUFJLENBQUMsVUFBVSxHQUFHLE1BQU0sQ0FBQyxTQUFTLENBQUM7UUFDbkMsSUFBSSxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUMsY0FBYyxDQUFDO1FBQzdDLElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsY0FBYyxHQUFHLE1BQU0sQ0FBQyxhQUFhLENBQUM7UUFDM0MsSUFBSSxDQUFDLFFBQVEsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDO1FBQy9CLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxNQUFNLENBQUMsZUFBZSxDQUFDO1FBQy9DLElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLFlBQVksQ0FBQztRQUN6QyxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxZQUFZLENBQUM7UUFDekMsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztJQUMzQixDQUFDO0lBUUQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMscUJBQXFCLENBQUM7SUFDcEMsQ0FBQztJQUNELElBQVcsb0JBQW9CLENBQUMsS0FBeUI7UUFDdkQsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQztJQUNyQyxDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUNELElBQVcsaUJBQWlCLENBQUMsS0FBMkI7UUFDdEQsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztJQUNsQyxDQUFDO0lBSUQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsb0JBQW9CLENBQUM7SUFDbkMsQ0FBQztJQUNELElBQVcsbUJBQW1CLENBQUMsS0FBeUI7UUFDdEQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQztJQUNwQyxDQUFDO0lBSUQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsc0JBQXNCLENBQUM7SUFDckMsQ0FBQztJQUNELElBQVcscUJBQXFCLENBQUMsS0FBeUI7UUFDeEQsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQztJQUN0QyxDQUFDO0lBSUQsSUFBVyxTQUFTOztRQUNsQixhQUFPLElBQUksQ0FBQyxVQUFVLG1DQUFJLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUNuRSxDQUFDO0lBQ0QsSUFBVyxTQUFTLENBQUMsS0FBMEI7UUFDN0MsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFDMUIsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7SUFDRCxJQUFXLGdCQUFnQixDQUFDLEtBQXlCO1FBQ25ELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7SUFDakMsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBeUI7UUFDdkMsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUlELElBQVcsRUFBRTs7UUFDWCxhQUFPLElBQUksQ0FBQyxHQUFHLG1DQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBQ0QsSUFBVyxFQUFFLENBQUMsS0FBeUI7UUFDckMsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUM7SUFDbkIsQ0FBQztJQUlELElBQVcsNEJBQTRCO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLDZCQUE2QixDQUFDO0lBQzVDLENBQUM7SUFDRCxJQUFXLDRCQUE0QixDQUFDLEtBQXlCO1FBQy9ELElBQUksQ0FBQyw2QkFBNkIsR0FBRyxLQUFLLENBQUM7SUFDN0MsQ0FBQztJQUlELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDO0lBQ2pDLENBQUM7SUFDRCxJQUFXLGlCQUFpQixDQUFDLEtBQTBCO1FBQ3JELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUNELElBQVcsU0FBUyxDQUFDLEtBQXlCO1FBQzVDLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO0lBQzFCLENBQUM7SUFJRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7SUFDRCxJQUFXLGNBQWMsQ0FBQyxLQUEwQjtRQUNsRCxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQztJQUMvQixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUF5QjtRQUN2QyxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBSUQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDO0lBQ0QsSUFBVyxhQUFhLENBQUMsS0FBeUI7UUFDaEQsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7SUFDOUIsQ0FBQztJQUlELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUNELElBQVcsT0FBTyxDQUFDLEtBQTJCO1FBQzVDLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDO0lBQ3hCLENBQUM7SUFJRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQXlCO1FBQ2xELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUM7SUFDaEMsQ0FBQztJQUlELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUM7SUFDNUIsQ0FBQztJQUNELElBQVcsWUFBWSxDQUFDLEtBQXlCO1FBQy9DLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzdCLENBQUM7SUFJRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFDRCxJQUFXLFlBQVksQ0FBQyxLQUF5QjtRQUMvQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUE0QztRQUMxRCxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFhO1FBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFFRCxZQUFZO0lBQ1osWUFBWTtJQUNaLFlBQVk7SUFFTCxvQkFBb0I7UUFDekIsT0FBTztZQUNMLHNCQUFzQixFQUFFLElBQUksQ0FBQyxxQkFBcUI7WUFDbEQsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtZQUMzQyxxQkFBcUIsRUFBRSxJQUFJLENBQUMsb0JBQW9CO1lBQ2hELHVCQUF1QixFQUFFLElBQUksQ0FBQyxzQkFBc0I7WUFDcEQsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQzNCLGlCQUFpQixFQUFFLElBQUksQ0FBQyxpQkFBaUI7WUFDekMsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLO1lBQ2hCLCtCQUErQixFQUFFLElBQUksQ0FBQyw2QkFBNkI7WUFDbkUsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtZQUMzQyxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7WUFDM0IsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlO1lBQ3JDLElBQUksRUFBRSxJQUFJLENBQUMsS0FBSztZQUNoQixjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsT0FBTyxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3RCLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7WUFDdkMsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhO1lBQ2pDLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTtZQUNqQyxJQUFJLEVBQUUsSUFBSSxDQUFDLEtBQUs7WUFDaEIsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLO1NBQ2pCLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUF6UEQsZ0RBeVBDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F3cy9yL3JvdXRlNTNfaGVhbHRoX2NoZWNrLmh0bWxcbi8vIGdlbmVyYXRlZCBmcm9tIHRlcnJhZm9ybSByZXNvdXJjZSBzY2hlbWFcblxuLypcbntcbiAgXCJ2ZXJzaW9uXCI6IDAsXG4gIFwiYmxvY2tcIjoge1xuICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICBcImNoaWxkX2hlYWx0aF90aHJlc2hvbGRcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJudW1iZXJcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJjaGlsZF9oZWFsdGhjaGVja3NcIjoge1xuICAgICAgICBcInR5cGVcIjogW1xuICAgICAgICAgIFwic2V0XCIsXG4gICAgICAgICAgXCJzdHJpbmdcIlxuICAgICAgICBdLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImNsb3Vkd2F0Y2hfYWxhcm1fbmFtZVwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImNsb3Vkd2F0Y2hfYWxhcm1fcmVnaW9uXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiZW5hYmxlX3NuaVwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcImJvb2xcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImZhaWx1cmVfdGhyZXNob2xkXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwibnVtYmVyXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiZnFkblwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImlkXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZSxcbiAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJpbnN1ZmZpY2llbnRfZGF0YV9oZWFsdGhfc3RhdHVzXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiaW52ZXJ0X2hlYWx0aGNoZWNrXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwiYm9vbFwiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImlwX2FkZHJlc3NcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJtZWFzdXJlX2xhdGVuY3lcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJib29sXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwicG9ydFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcIm51bWJlclwiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInJlZmVyZW5jZV9uYW1lXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwicmVnaW9uc1wiOiB7XG4gICAgICAgIFwidHlwZVwiOiBbXG4gICAgICAgICAgXCJzZXRcIixcbiAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgIF0sXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwicmVxdWVzdF9pbnRlcnZhbFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcIm51bWJlclwiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInJlc291cmNlX3BhdGhcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJzZWFyY2hfc3RyaW5nXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwidGFnc1wiOiB7XG4gICAgICAgIFwidHlwZVwiOiBbXG4gICAgICAgICAgXCJtYXBcIixcbiAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgIF0sXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwidHlwZVwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgIH1cbiAgICB9XG4gIH1cbn1cbiovXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IFRlcnJhZm9ybVJlc291cmNlIH0gZnJvbSAnY2RrdGYnO1xuaW1wb3J0IHsgVGVycmFmb3JtTWV0YUFyZ3VtZW50cyB9IGZyb20gJ2Nka3RmJztcblxuLy8gQ29uZmlndXJhdGlvblxuXG5leHBvcnQgaW50ZXJmYWNlIFJvdXRlNTNIZWFsdGhDaGVja0NvbmZpZyBleHRlbmRzIFRlcnJhZm9ybU1ldGFBcmd1bWVudHMge1xuICByZWFkb25seSBjaGlsZEhlYWx0aFRocmVzaG9sZD86IG51bWJlcjtcbiAgcmVhZG9ubHkgY2hpbGRIZWFsdGhjaGVja3M/OiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgY2xvdWR3YXRjaEFsYXJtTmFtZT86IHN0cmluZztcbiAgcmVhZG9ubHkgY2xvdWR3YXRjaEFsYXJtUmVnaW9uPzogc3RyaW5nO1xuICByZWFkb25seSBlbmFibGVTbmk/OiBib29sZWFuO1xuICByZWFkb25seSBmYWlsdXJlVGhyZXNob2xkPzogbnVtYmVyO1xuICByZWFkb25seSBmcWRuPzogc3RyaW5nO1xuICByZWFkb25seSBpbnN1ZmZpY2llbnREYXRhSGVhbHRoU3RhdHVzPzogc3RyaW5nO1xuICByZWFkb25seSBpbnZlcnRIZWFsdGhjaGVjaz86IGJvb2xlYW47XG4gIHJlYWRvbmx5IGlwQWRkcmVzcz86IHN0cmluZztcbiAgcmVhZG9ubHkgbWVhc3VyZUxhdGVuY3k/OiBib29sZWFuO1xuICByZWFkb25seSBwb3J0PzogbnVtYmVyO1xuICByZWFkb25seSByZWZlcmVuY2VOYW1lPzogc3RyaW5nO1xuICByZWFkb25seSByZWdpb25zPzogc3RyaW5nW107XG4gIHJlYWRvbmx5IHJlcXVlc3RJbnRlcnZhbD86IG51bWJlcjtcbiAgcmVhZG9ubHkgcmVzb3VyY2VQYXRoPzogc3RyaW5nO1xuICByZWFkb25seSBzZWFyY2hTdHJpbmc/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHRhZ3M/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9O1xuICByZWFkb25seSB0eXBlOiBzdHJpbmc7XG59XG5cbi8vIFJlc291cmNlXG5cbmV4cG9ydCBjbGFzcyBSb3V0ZTUzSGVhbHRoQ2hlY2sgZXh0ZW5kcyBUZXJyYWZvcm1SZXNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBSb3V0ZTUzSGVhbHRoQ2hlY2tDb25maWcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHRlcnJhZm9ybVJlc291cmNlVHlwZTogJ2F3c19yb3V0ZTUzX2hlYWx0aF9jaGVjaycsXG4gICAgICB0ZXJyYWZvcm1HZW5lcmF0b3JNZXRhZGF0YToge1xuICAgICAgICBwcm92aWRlck5hbWU6ICdhd3MnXG4gICAgICB9LFxuICAgICAgcHJvdmlkZXI6IGNvbmZpZy5wcm92aWRlcixcbiAgICAgIGRlcGVuZHNPbjogY29uZmlnLmRlcGVuZHNPbixcbiAgICAgIGNvdW50OiBjb25maWcuY291bnQsXG4gICAgICBsaWZlY3ljbGU6IGNvbmZpZy5saWZlY3ljbGVcbiAgICB9KTtcbiAgICB0aGlzLl9jaGlsZEhlYWx0aFRocmVzaG9sZCA9IGNvbmZpZy5jaGlsZEhlYWx0aFRocmVzaG9sZDtcbiAgICB0aGlzLl9jaGlsZEhlYWx0aGNoZWNrcyA9IGNvbmZpZy5jaGlsZEhlYWx0aGNoZWNrcztcbiAgICB0aGlzLl9jbG91ZHdhdGNoQWxhcm1OYW1lID0gY29uZmlnLmNsb3Vkd2F0Y2hBbGFybU5hbWU7XG4gICAgdGhpcy5fY2xvdWR3YXRjaEFsYXJtUmVnaW9uID0gY29uZmlnLmNsb3Vkd2F0Y2hBbGFybVJlZ2lvbjtcbiAgICB0aGlzLl9lbmFibGVTbmkgPSBjb25maWcuZW5hYmxlU25pO1xuICAgIHRoaXMuX2ZhaWx1cmVUaHJlc2hvbGQgPSBjb25maWcuZmFpbHVyZVRocmVzaG9sZDtcbiAgICB0aGlzLl9mcWRuID0gY29uZmlnLmZxZG47XG4gICAgdGhpcy5faW5zdWZmaWNpZW50RGF0YUhlYWx0aFN0YXR1cyA9IGNvbmZpZy5pbnN1ZmZpY2llbnREYXRhSGVhbHRoU3RhdHVzO1xuICAgIHRoaXMuX2ludmVydEhlYWx0aGNoZWNrID0gY29uZmlnLmludmVydEhlYWx0aGNoZWNrO1xuICAgIHRoaXMuX2lwQWRkcmVzcyA9IGNvbmZpZy5pcEFkZHJlc3M7XG4gICAgdGhpcy5fbWVhc3VyZUxhdGVuY3kgPSBjb25maWcubWVhc3VyZUxhdGVuY3k7XG4gICAgdGhpcy5fcG9ydCA9IGNvbmZpZy5wb3J0O1xuICAgIHRoaXMuX3JlZmVyZW5jZU5hbWUgPSBjb25maWcucmVmZXJlbmNlTmFtZTtcbiAgICB0aGlzLl9yZWdpb25zID0gY29uZmlnLnJlZ2lvbnM7XG4gICAgdGhpcy5fcmVxdWVzdEludGVydmFsID0gY29uZmlnLnJlcXVlc3RJbnRlcnZhbDtcbiAgICB0aGlzLl9yZXNvdXJjZVBhdGggPSBjb25maWcucmVzb3VyY2VQYXRoO1xuICAgIHRoaXMuX3NlYXJjaFN0cmluZyA9IGNvbmZpZy5zZWFyY2hTdHJpbmc7XG4gICAgdGhpcy5fdGFncyA9IGNvbmZpZy50YWdzO1xuICAgIHRoaXMuX3R5cGUgPSBjb25maWcudHlwZTtcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gY2hpbGRfaGVhbHRoX3RocmVzaG9sZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jaGlsZEhlYWx0aFRocmVzaG9sZD86IG51bWJlcjtcbiAgcHVibGljIGdldCBjaGlsZEhlYWx0aFRocmVzaG9sZCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2hpbGRIZWFsdGhUaHJlc2hvbGQ7XG4gIH1cbiAgcHVibGljIHNldCBjaGlsZEhlYWx0aFRocmVzaG9sZCh2YWx1ZTogbnVtYmVyIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fY2hpbGRIZWFsdGhUaHJlc2hvbGQgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGNoaWxkX2hlYWx0aGNoZWNrcyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jaGlsZEhlYWx0aGNoZWNrcz86IHN0cmluZ1tdO1xuICBwdWJsaWMgZ2V0IGNoaWxkSGVhbHRoY2hlY2tzKCkge1xuICAgIHJldHVybiB0aGlzLl9jaGlsZEhlYWx0aGNoZWNrcztcbiAgfVxuICBwdWJsaWMgc2V0IGNoaWxkSGVhbHRoY2hlY2tzKHZhbHVlOiBzdHJpbmdbXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2NoaWxkSGVhbHRoY2hlY2tzID0gdmFsdWU7XG4gIH1cblxuICAvLyBjbG91ZHdhdGNoX2FsYXJtX25hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY2xvdWR3YXRjaEFsYXJtTmFtZT86IHN0cmluZztcbiAgcHVibGljIGdldCBjbG91ZHdhdGNoQWxhcm1OYW1lKCkge1xuICAgIHJldHVybiB0aGlzLl9jbG91ZHdhdGNoQWxhcm1OYW1lO1xuICB9XG4gIHB1YmxpYyBzZXQgY2xvdWR3YXRjaEFsYXJtTmFtZSh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fY2xvdWR3YXRjaEFsYXJtTmFtZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gY2xvdWR3YXRjaF9hbGFybV9yZWdpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY2xvdWR3YXRjaEFsYXJtUmVnaW9uPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGNsb3Vkd2F0Y2hBbGFybVJlZ2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy5fY2xvdWR3YXRjaEFsYXJtUmVnaW9uO1xuICB9XG4gIHB1YmxpYyBzZXQgY2xvdWR3YXRjaEFsYXJtUmVnaW9uKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9jbG91ZHdhdGNoQWxhcm1SZWdpb24gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGVuYWJsZV9zbmkgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9lbmFibGVTbmk/OiBib29sZWFuO1xuICBwdWJsaWMgZ2V0IGVuYWJsZVNuaSgpIHtcbiAgICByZXR1cm4gdGhpcy5fZW5hYmxlU25pID8/IHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnZW5hYmxlX3NuaScpO1xuICB9XG4gIHB1YmxpYyBzZXQgZW5hYmxlU25pKHZhbHVlOiBib29sZWFuIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fZW5hYmxlU25pID0gdmFsdWU7XG4gIH1cblxuICAvLyBmYWlsdXJlX3RocmVzaG9sZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9mYWlsdXJlVGhyZXNob2xkPzogbnVtYmVyO1xuICBwdWJsaWMgZ2V0IGZhaWx1cmVUaHJlc2hvbGQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2ZhaWx1cmVUaHJlc2hvbGQ7XG4gIH1cbiAgcHVibGljIHNldCBmYWlsdXJlVGhyZXNob2xkKHZhbHVlOiBudW1iZXIgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9mYWlsdXJlVGhyZXNob2xkID0gdmFsdWU7XG4gIH1cblxuICAvLyBmcWRuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2ZxZG4/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgZnFkbigpIHtcbiAgICByZXR1cm4gdGhpcy5fZnFkbjtcbiAgfVxuICBwdWJsaWMgc2V0IGZxZG4odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2ZxZG4gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGlkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaWQ/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgaWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lkID8/IHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdpZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaWQodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2lkID0gdmFsdWU7XG4gIH1cblxuICAvLyBpbnN1ZmZpY2llbnRfZGF0YV9oZWFsdGhfc3RhdHVzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2luc3VmZmljaWVudERhdGFIZWFsdGhTdGF0dXM/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgaW5zdWZmaWNpZW50RGF0YUhlYWx0aFN0YXR1cygpIHtcbiAgICByZXR1cm4gdGhpcy5faW5zdWZmaWNpZW50RGF0YUhlYWx0aFN0YXR1cztcbiAgfVxuICBwdWJsaWMgc2V0IGluc3VmZmljaWVudERhdGFIZWFsdGhTdGF0dXModmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2luc3VmZmljaWVudERhdGFIZWFsdGhTdGF0dXMgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGludmVydF9oZWFsdGhjaGVjayAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pbnZlcnRIZWFsdGhjaGVjaz86IGJvb2xlYW47XG4gIHB1YmxpYyBnZXQgaW52ZXJ0SGVhbHRoY2hlY2soKSB7XG4gICAgcmV0dXJuIHRoaXMuX2ludmVydEhlYWx0aGNoZWNrO1xuICB9XG4gIHB1YmxpYyBzZXQgaW52ZXJ0SGVhbHRoY2hlY2sodmFsdWU6IGJvb2xlYW4gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9pbnZlcnRIZWFsdGhjaGVjayA9IHZhbHVlO1xuICB9XG5cbiAgLy8gaXBfYWRkcmVzcyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pcEFkZHJlc3M/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgaXBBZGRyZXNzKCkge1xuICAgIHJldHVybiB0aGlzLl9pcEFkZHJlc3M7XG4gIH1cbiAgcHVibGljIHNldCBpcEFkZHJlc3ModmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2lwQWRkcmVzcyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gbWVhc3VyZV9sYXRlbmN5IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21lYXN1cmVMYXRlbmN5PzogYm9vbGVhbjtcbiAgcHVibGljIGdldCBtZWFzdXJlTGF0ZW5jeSgpIHtcbiAgICByZXR1cm4gdGhpcy5fbWVhc3VyZUxhdGVuY3k7XG4gIH1cbiAgcHVibGljIHNldCBtZWFzdXJlTGF0ZW5jeSh2YWx1ZTogYm9vbGVhbiB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX21lYXN1cmVMYXRlbmN5ID0gdmFsdWU7XG4gIH1cblxuICAvLyBwb3J0IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3BvcnQ/OiBudW1iZXI7XG4gIHB1YmxpYyBnZXQgcG9ydCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcG9ydDtcbiAgfVxuICBwdWJsaWMgc2V0IHBvcnQodmFsdWU6IG51bWJlciB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3BvcnQgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHJlZmVyZW5jZV9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JlZmVyZW5jZU5hbWU/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgcmVmZXJlbmNlTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5fcmVmZXJlbmNlTmFtZTtcbiAgfVxuICBwdWJsaWMgc2V0IHJlZmVyZW5jZU5hbWUodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3JlZmVyZW5jZU5hbWUgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHJlZ2lvbnMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVnaW9ucz86IHN0cmluZ1tdO1xuICBwdWJsaWMgZ2V0IHJlZ2lvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlZ2lvbnM7XG4gIH1cbiAgcHVibGljIHNldCByZWdpb25zKHZhbHVlOiBzdHJpbmdbXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3JlZ2lvbnMgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHJlcXVlc3RfaW50ZXJ2YWwgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVxdWVzdEludGVydmFsPzogbnVtYmVyO1xuICBwdWJsaWMgZ2V0IHJlcXVlc3RJbnRlcnZhbCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcmVxdWVzdEludGVydmFsO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVxdWVzdEludGVydmFsKHZhbHVlOiBudW1iZXIgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9yZXF1ZXN0SW50ZXJ2YWwgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHJlc291cmNlX3BhdGggLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVzb3VyY2VQYXRoPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IHJlc291cmNlUGF0aCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcmVzb3VyY2VQYXRoO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVzb3VyY2VQYXRoKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9yZXNvdXJjZVBhdGggPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHNlYXJjaF9zdHJpbmcgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc2VhcmNoU3RyaW5nPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IHNlYXJjaFN0cmluZygpIHtcbiAgICByZXR1cm4gdGhpcy5fc2VhcmNoU3RyaW5nO1xuICB9XG4gIHB1YmxpYyBzZXQgc2VhcmNoU3RyaW5nKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9zZWFyY2hTdHJpbmcgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHRhZ3MgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdGFncz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG4gIHB1YmxpYyBnZXQgdGFncygpIHtcbiAgICByZXR1cm4gdGhpcy5fdGFncztcbiAgfVxuICBwdWJsaWMgc2V0IHRhZ3ModmFsdWU6IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH0gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl90YWdzID0gdmFsdWU7XG4gIH1cblxuICAvLyB0eXBlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX3R5cGU6IHN0cmluZztcbiAgcHVibGljIGdldCB0eXBlKCkge1xuICAgIHJldHVybiB0aGlzLl90eXBlO1xuICB9XG4gIHB1YmxpYyBzZXQgdHlwZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fdHlwZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gPT09PT09PT09XG4gIC8vIFNZTlRIRVNJU1xuICAvLyA9PT09PT09PT1cblxuICBwdWJsaWMgc3ludGhlc2l6ZUF0dHJpYnV0ZXMoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIHJldHVybiB7XG4gICAgICBjaGlsZF9oZWFsdGhfdGhyZXNob2xkOiB0aGlzLl9jaGlsZEhlYWx0aFRocmVzaG9sZCxcbiAgICAgIGNoaWxkX2hlYWx0aGNoZWNrczogdGhpcy5fY2hpbGRIZWFsdGhjaGVja3MsXG4gICAgICBjbG91ZHdhdGNoX2FsYXJtX25hbWU6IHRoaXMuX2Nsb3Vkd2F0Y2hBbGFybU5hbWUsXG4gICAgICBjbG91ZHdhdGNoX2FsYXJtX3JlZ2lvbjogdGhpcy5fY2xvdWR3YXRjaEFsYXJtUmVnaW9uLFxuICAgICAgZW5hYmxlX3NuaTogdGhpcy5fZW5hYmxlU25pLFxuICAgICAgZmFpbHVyZV90aHJlc2hvbGQ6IHRoaXMuX2ZhaWx1cmVUaHJlc2hvbGQsXG4gICAgICBmcWRuOiB0aGlzLl9mcWRuLFxuICAgICAgaW5zdWZmaWNpZW50X2RhdGFfaGVhbHRoX3N0YXR1czogdGhpcy5faW5zdWZmaWNpZW50RGF0YUhlYWx0aFN0YXR1cyxcbiAgICAgIGludmVydF9oZWFsdGhjaGVjazogdGhpcy5faW52ZXJ0SGVhbHRoY2hlY2ssXG4gICAgICBpcF9hZGRyZXNzOiB0aGlzLl9pcEFkZHJlc3MsXG4gICAgICBtZWFzdXJlX2xhdGVuY3k6IHRoaXMuX21lYXN1cmVMYXRlbmN5LFxuICAgICAgcG9ydDogdGhpcy5fcG9ydCxcbiAgICAgIHJlZmVyZW5jZV9uYW1lOiB0aGlzLl9yZWZlcmVuY2VOYW1lLFxuICAgICAgcmVnaW9uczogdGhpcy5fcmVnaW9ucyxcbiAgICAgIHJlcXVlc3RfaW50ZXJ2YWw6IHRoaXMuX3JlcXVlc3RJbnRlcnZhbCxcbiAgICAgIHJlc291cmNlX3BhdGg6IHRoaXMuX3Jlc291cmNlUGF0aCxcbiAgICAgIHNlYXJjaF9zdHJpbmc6IHRoaXMuX3NlYXJjaFN0cmluZyxcbiAgICAgIHRhZ3M6IHRoaXMuX3RhZ3MsXG4gICAgICB0eXBlOiB0aGlzLl90eXBlLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==