import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Route53RecordConfig extends TerraformMetaArguments {
    readonly allowOverwrite?: boolean;
    readonly healthCheckId?: string;
    readonly multivalueAnswerRoutingPolicy?: boolean;
    readonly name: string;
    readonly records?: string[];
    readonly setIdentifier?: string;
    readonly ttl?: number;
    readonly type: string;
    readonly zoneId: string;
    /** alias block */
    readonly alias?: Route53RecordAlias[];
    /** failover_routing_policy block */
    readonly failoverRoutingPolicy?: Route53RecordFailoverRoutingPolicy[];
    /** geolocation_routing_policy block */
    readonly geolocationRoutingPolicy?: Route53RecordGeolocationRoutingPolicy[];
    /** latency_routing_policy block */
    readonly latencyRoutingPolicy?: Route53RecordLatencyRoutingPolicy[];
    /** weighted_routing_policy block */
    readonly weightedRoutingPolicy?: Route53RecordWeightedRoutingPolicy[];
}
export interface Route53RecordAlias {
    readonly evaluateTargetHealth: boolean;
    readonly name: string;
    readonly zoneId: string;
}
export interface Route53RecordFailoverRoutingPolicy {
    readonly type: string;
}
export interface Route53RecordGeolocationRoutingPolicy {
    readonly continent?: string;
    readonly country?: string;
    readonly subdivision?: string;
}
export interface Route53RecordLatencyRoutingPolicy {
    readonly region: string;
}
export interface Route53RecordWeightedRoutingPolicy {
    readonly weight: number;
}
export declare class Route53Record extends TerraformResource {
    constructor(scope: Construct, id: string, config: Route53RecordConfig);
    private _allowOverwrite?;
    get allowOverwrite(): boolean | undefined;
    set allowOverwrite(value: boolean | undefined);
    get fqdn(): string;
    private _healthCheckId?;
    get healthCheckId(): string | undefined;
    set healthCheckId(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _multivalueAnswerRoutingPolicy?;
    get multivalueAnswerRoutingPolicy(): boolean | undefined;
    set multivalueAnswerRoutingPolicy(value: boolean | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _records?;
    get records(): string[] | undefined;
    set records(value: string[] | undefined);
    private _setIdentifier?;
    get setIdentifier(): string | undefined;
    set setIdentifier(value: string | undefined);
    private _ttl?;
    get ttl(): number | undefined;
    set ttl(value: number | undefined);
    private _type;
    get type(): string;
    set type(value: string);
    private _zoneId;
    get zoneId(): string;
    set zoneId(value: string);
    private _alias?;
    get alias(): Route53RecordAlias[] | undefined;
    set alias(value: Route53RecordAlias[] | undefined);
    private _failoverRoutingPolicy?;
    get failoverRoutingPolicy(): Route53RecordFailoverRoutingPolicy[] | undefined;
    set failoverRoutingPolicy(value: Route53RecordFailoverRoutingPolicy[] | undefined);
    private _geolocationRoutingPolicy?;
    get geolocationRoutingPolicy(): Route53RecordGeolocationRoutingPolicy[] | undefined;
    set geolocationRoutingPolicy(value: Route53RecordGeolocationRoutingPolicy[] | undefined);
    private _latencyRoutingPolicy?;
    get latencyRoutingPolicy(): Route53RecordLatencyRoutingPolicy[] | undefined;
    set latencyRoutingPolicy(value: Route53RecordLatencyRoutingPolicy[] | undefined);
    private _weightedRoutingPolicy?;
    get weightedRoutingPolicy(): Route53RecordWeightedRoutingPolicy[] | undefined;
    set weightedRoutingPolicy(value: Route53RecordWeightedRoutingPolicy[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
