"use strict";
// https://www.terraform.io/docs/providers/aws/r/route53_record.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53Record = void 0;
const cdktf_1 = require("cdktf");
// Resource
class Route53Record extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_route53_record',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._allowOverwrite = config.allowOverwrite;
        this._healthCheckId = config.healthCheckId;
        this._multivalueAnswerRoutingPolicy = config.multivalueAnswerRoutingPolicy;
        this._name = config.name;
        this._records = config.records;
        this._setIdentifier = config.setIdentifier;
        this._ttl = config.ttl;
        this._type = config.type;
        this._zoneId = config.zoneId;
        this._alias = config.alias;
        this._failoverRoutingPolicy = config.failoverRoutingPolicy;
        this._geolocationRoutingPolicy = config.geolocationRoutingPolicy;
        this._latencyRoutingPolicy = config.latencyRoutingPolicy;
        this._weightedRoutingPolicy = config.weightedRoutingPolicy;
    }
    get allowOverwrite() {
        var _a;
        return (_a = this._allowOverwrite) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('allow_overwrite');
    }
    set allowOverwrite(value) {
        this._allowOverwrite = value;
    }
    // fqdn - computed: true, optional: false, required: true
    get fqdn() {
        return this.getStringAttribute('fqdn');
    }
    get healthCheckId() {
        return this._healthCheckId;
    }
    set healthCheckId(value) {
        this._healthCheckId = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get multivalueAnswerRoutingPolicy() {
        return this._multivalueAnswerRoutingPolicy;
    }
    set multivalueAnswerRoutingPolicy(value) {
        this._multivalueAnswerRoutingPolicy = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get records() {
        return this._records;
    }
    set records(value) {
        this._records = value;
    }
    get setIdentifier() {
        return this._setIdentifier;
    }
    set setIdentifier(value) {
        this._setIdentifier = value;
    }
    get ttl() {
        return this._ttl;
    }
    set ttl(value) {
        this._ttl = value;
    }
    get type() {
        return this._type;
    }
    set type(value) {
        this._type = value;
    }
    get zoneId() {
        return this._zoneId;
    }
    set zoneId(value) {
        this._zoneId = value;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    get failoverRoutingPolicy() {
        return this._failoverRoutingPolicy;
    }
    set failoverRoutingPolicy(value) {
        this._failoverRoutingPolicy = value;
    }
    get geolocationRoutingPolicy() {
        return this._geolocationRoutingPolicy;
    }
    set geolocationRoutingPolicy(value) {
        this._geolocationRoutingPolicy = value;
    }
    get latencyRoutingPolicy() {
        return this._latencyRoutingPolicy;
    }
    set latencyRoutingPolicy(value) {
        this._latencyRoutingPolicy = value;
    }
    get weightedRoutingPolicy() {
        return this._weightedRoutingPolicy;
    }
    set weightedRoutingPolicy(value) {
        this._weightedRoutingPolicy = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_overwrite: this._allowOverwrite,
            health_check_id: this._healthCheckId,
            multivalue_answer_routing_policy: this._multivalueAnswerRoutingPolicy,
            name: this._name,
            records: this._records,
            set_identifier: this._setIdentifier,
            ttl: this._ttl,
            type: this._type,
            zone_id: this._zoneId,
            alias: this._alias,
            failover_routing_policy: this._failoverRoutingPolicy,
            geolocation_routing_policy: this._geolocationRoutingPolicy,
            latency_routing_policy: this._latencyRoutingPolicy,
            weighted_routing_policy: this._weightedRoutingPolicy,
        };
    }
}
exports.Route53Record = Route53Record;
//# sourceMappingURL=data:application/json;base64,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