import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Route53ResolverEndpointConfig extends TerraformMetaArguments {
    readonly direction: string;
    readonly name?: string;
    readonly securityGroupIds: string[];
    readonly tags?: {
        [key: string]: string;
    };
    /** ip_address block */
    readonly ipAddress: Route53ResolverEndpointIpAddress[];
    /** timeouts block */
    readonly timeouts?: Route53ResolverEndpointTimeouts;
}
export interface Route53ResolverEndpointIpAddress {
    readonly ip?: string;
    readonly subnetId: string;
}
export interface Route53ResolverEndpointTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class Route53ResolverEndpoint extends TerraformResource {
    constructor(scope: Construct, id: string, config: Route53ResolverEndpointConfig);
    get arn(): string;
    private _direction;
    get direction(): string;
    set direction(value: string);
    get hostVpcId(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _securityGroupIds;
    get securityGroupIds(): string[];
    set securityGroupIds(value: string[]);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _ipAddress;
    get ipAddress(): Route53ResolverEndpointIpAddress[];
    set ipAddress(value: Route53ResolverEndpointIpAddress[]);
    private _timeouts?;
    get timeouts(): Route53ResolverEndpointTimeouts | undefined;
    set timeouts(value: Route53ResolverEndpointTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
