import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Route53ResolverRuleConfig extends TerraformMetaArguments {
    readonly domainName: string;
    readonly name?: string;
    readonly resolverEndpointId?: string;
    readonly ruleType: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** target_ip block */
    readonly targetIp?: Route53ResolverRuleTargetIp[];
    /** timeouts block */
    readonly timeouts?: Route53ResolverRuleTimeouts;
}
export interface Route53ResolverRuleTargetIp {
    readonly ip: string;
    readonly port?: number;
}
export interface Route53ResolverRuleTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class Route53ResolverRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: Route53ResolverRuleConfig);
    get arn(): string;
    private _domainName;
    get domainName(): string;
    set domainName(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    get ownerId(): string;
    private _resolverEndpointId?;
    get resolverEndpointId(): string | undefined;
    set resolverEndpointId(value: string | undefined);
    private _ruleType;
    get ruleType(): string;
    set ruleType(value: string);
    get shareStatus(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _targetIp?;
    get targetIp(): Route53ResolverRuleTargetIp[] | undefined;
    set targetIp(value: Route53ResolverRuleTargetIp[] | undefined);
    private _timeouts?;
    get timeouts(): Route53ResolverRuleTimeouts | undefined;
    set timeouts(value: Route53ResolverRuleTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
