import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Route53ZoneConfig extends TerraformMetaArguments {
    readonly comment?: string;
    readonly delegationSetId?: string;
    readonly forceDestroy?: boolean;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcId?: string;
    readonly vpcRegion?: string;
    /** vpc block */
    readonly vpc?: Route53ZoneVpc[];
}
export interface Route53ZoneVpc {
    readonly vpcId: string;
    readonly vpcRegion?: string;
}
export declare class Route53Zone extends TerraformResource {
    constructor(scope: Construct, id: string, config: Route53ZoneConfig);
    private _comment?;
    get comment(): string | undefined;
    set comment(value: string | undefined);
    private _delegationSetId?;
    get delegationSetId(): string | undefined;
    set delegationSetId(value: string | undefined);
    private _forceDestroy?;
    get forceDestroy(): boolean | undefined;
    set forceDestroy(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    get nameServers(): string[];
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcId?;
    get vpcId(): string | undefined;
    set vpcId(value: string | undefined);
    private _vpcRegion?;
    get vpcRegion(): string | undefined;
    set vpcRegion(value: string | undefined);
    get zoneId(): string;
    private _vpc?;
    get vpc(): Route53ZoneVpc[] | undefined;
    set vpc(value: Route53ZoneVpc[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
