import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface S3AccessPointConfig extends TerraformMetaArguments {
    readonly accountId?: string;
    readonly bucket: string;
    readonly name: string;
    readonly policy?: string;
    /** public_access_block_configuration block */
    readonly publicAccessBlockConfiguration?: S3AccessPointPublicAccessBlockConfiguration[];
    /** vpc_configuration block */
    readonly vpcConfiguration?: S3AccessPointVpcConfiguration[];
}
export interface S3AccessPointPublicAccessBlockConfiguration {
    readonly blockPublicAcls?: boolean;
    readonly blockPublicPolicy?: boolean;
    readonly ignorePublicAcls?: boolean;
    readonly restrictPublicBuckets?: boolean;
}
export interface S3AccessPointVpcConfiguration {
    readonly vpcId: string;
}
export declare class S3AccessPoint extends TerraformResource {
    constructor(scope: Construct, id: string, config: S3AccessPointConfig);
    private _accountId?;
    get accountId(): string | undefined;
    set accountId(value: string | undefined);
    get arn(): string;
    private _bucket;
    get bucket(): string;
    set bucket(value: string);
    get domainName(): string;
    get hasPublicAccessPolicy(): boolean;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    get networkOrigin(): string;
    private _policy?;
    get policy(): string | undefined;
    set policy(value: string | undefined);
    private _publicAccessBlockConfiguration?;
    get publicAccessBlockConfiguration(): S3AccessPointPublicAccessBlockConfiguration[] | undefined;
    set publicAccessBlockConfiguration(value: S3AccessPointPublicAccessBlockConfiguration[] | undefined);
    private _vpcConfiguration?;
    get vpcConfiguration(): S3AccessPointVpcConfiguration[] | undefined;
    set vpcConfiguration(value: S3AccessPointVpcConfiguration[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
