import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface S3AccountPublicAccessBlockConfig extends TerraformMetaArguments {
    readonly accountId?: string;
    readonly blockPublicAcls?: boolean;
    readonly blockPublicPolicy?: boolean;
    readonly ignorePublicAcls?: boolean;
    readonly restrictPublicBuckets?: boolean;
}
export declare class S3AccountPublicAccessBlock extends TerraformResource {
    constructor(scope: Construct, id: string, config?: S3AccountPublicAccessBlockConfig);
    private _accountId?;
    get accountId(): string | undefined;
    set accountId(value: string | undefined);
    private _blockPublicAcls?;
    get blockPublicAcls(): boolean | undefined;
    set blockPublicAcls(value: boolean | undefined);
    private _blockPublicPolicy?;
    get blockPublicPolicy(): boolean | undefined;
    set blockPublicPolicy(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ignorePublicAcls?;
    get ignorePublicAcls(): boolean | undefined;
    set ignorePublicAcls(value: boolean | undefined);
    private _restrictPublicBuckets?;
    get restrictPublicBuckets(): boolean | undefined;
    set restrictPublicBuckets(value: boolean | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
