import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface S3BucketAnalyticsConfigurationConfig extends TerraformMetaArguments {
    readonly bucket: string;
    readonly name: string;
    /** filter block */
    readonly filter?: S3BucketAnalyticsConfigurationFilter[];
    /** storage_class_analysis block */
    readonly storageClassAnalysis?: S3BucketAnalyticsConfigurationStorageClassAnalysis[];
}
export interface S3BucketAnalyticsConfigurationFilter {
    readonly prefix?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export interface S3BucketAnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination {
    readonly bucketAccountId?: string;
    readonly bucketArn: string;
    readonly format?: string;
    readonly prefix?: string;
}
export interface S3BucketAnalyticsConfigurationStorageClassAnalysisDataExportDestination {
    /** s3_bucket_destination block */
    readonly s3BucketDestination: S3BucketAnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination[];
}
export interface S3BucketAnalyticsConfigurationStorageClassAnalysisDataExport {
    readonly outputSchemaVersion?: string;
    /** destination block */
    readonly destination: S3BucketAnalyticsConfigurationStorageClassAnalysisDataExportDestination[];
}
export interface S3BucketAnalyticsConfigurationStorageClassAnalysis {
    /** data_export block */
    readonly dataExport: S3BucketAnalyticsConfigurationStorageClassAnalysisDataExport[];
}
export declare class S3BucketAnalyticsConfiguration extends TerraformResource {
    constructor(scope: Construct, id: string, config: S3BucketAnalyticsConfigurationConfig);
    private _bucket;
    get bucket(): string;
    set bucket(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _filter?;
    get filter(): S3BucketAnalyticsConfigurationFilter[] | undefined;
    set filter(value: S3BucketAnalyticsConfigurationFilter[] | undefined);
    private _storageClassAnalysis?;
    get storageClassAnalysis(): S3BucketAnalyticsConfigurationStorageClassAnalysis[] | undefined;
    set storageClassAnalysis(value: S3BucketAnalyticsConfigurationStorageClassAnalysis[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
