import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface S3BucketInventoryConfig extends TerraformMetaArguments {
    readonly bucket: string;
    readonly enabled?: boolean;
    readonly includedObjectVersions: string;
    readonly name: string;
    readonly optionalFields?: string[];
    /** destination block */
    readonly destination: S3BucketInventoryDestination[];
    /** filter block */
    readonly filter?: S3BucketInventoryFilter[];
    /** schedule block */
    readonly schedule: S3BucketInventorySchedule[];
}
export interface S3BucketInventoryDestinationBucketEncryptionSseKms {
    readonly keyId: string;
}
export interface S3BucketInventoryDestinationBucketEncryptionSseS3 {
}
export interface S3BucketInventoryDestinationBucketEncryption {
    /** sse_kms block */
    readonly sseKms?: S3BucketInventoryDestinationBucketEncryptionSseKms[];
    /** sse_s3 block */
    readonly sseS3?: S3BucketInventoryDestinationBucketEncryptionSseS3[];
}
export interface S3BucketInventoryDestinationBucket {
    readonly accountId?: string;
    readonly bucketArn: string;
    readonly format: string;
    readonly prefix?: string;
    /** encryption block */
    readonly encryption?: S3BucketInventoryDestinationBucketEncryption[];
}
export interface S3BucketInventoryDestination {
    /** bucket block */
    readonly bucket: S3BucketInventoryDestinationBucket[];
}
export interface S3BucketInventoryFilter {
    readonly prefix?: string;
}
export interface S3BucketInventorySchedule {
    readonly frequency: string;
}
export declare class S3BucketInventory extends TerraformResource {
    constructor(scope: Construct, id: string, config: S3BucketInventoryConfig);
    private _bucket;
    get bucket(): string;
    set bucket(value: string);
    private _enabled?;
    get enabled(): boolean | undefined;
    set enabled(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _includedObjectVersions;
    get includedObjectVersions(): string;
    set includedObjectVersions(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _optionalFields?;
    get optionalFields(): string[] | undefined;
    set optionalFields(value: string[] | undefined);
    private _destination;
    get destination(): S3BucketInventoryDestination[];
    set destination(value: S3BucketInventoryDestination[]);
    private _filter?;
    get filter(): S3BucketInventoryFilter[] | undefined;
    set filter(value: S3BucketInventoryFilter[] | undefined);
    private _schedule;
    get schedule(): S3BucketInventorySchedule[];
    set schedule(value: S3BucketInventorySchedule[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
