import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface S3BucketMetricConfig extends TerraformMetaArguments {
    readonly bucket: string;
    readonly name: string;
    /** filter block */
    readonly filter?: S3BucketMetricFilter[];
}
export interface S3BucketMetricFilter {
    readonly prefix?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class S3BucketMetric extends TerraformResource {
    constructor(scope: Construct, id: string, config: S3BucketMetricConfig);
    private _bucket;
    get bucket(): string;
    set bucket(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _filter?;
    get filter(): S3BucketMetricFilter[] | undefined;
    set filter(value: S3BucketMetricFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
