import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface S3BucketNotificationConfig extends TerraformMetaArguments {
    readonly bucket: string;
    /** lambda_function block */
    readonly lambdaFunction?: S3BucketNotificationLambdaFunction[];
    /** queue block */
    readonly queue?: S3BucketNotificationQueue[];
    /** topic block */
    readonly topic?: S3BucketNotificationTopic[];
}
export interface S3BucketNotificationLambdaFunction {
    readonly events: string[];
    readonly filterPrefix?: string;
    readonly filterSuffix?: string;
    readonly id?: string;
    readonly lambdaFunctionArn?: string;
}
export interface S3BucketNotificationQueue {
    readonly events: string[];
    readonly filterPrefix?: string;
    readonly filterSuffix?: string;
    readonly id?: string;
    readonly queueArn: string;
}
export interface S3BucketNotificationTopic {
    readonly events: string[];
    readonly filterPrefix?: string;
    readonly filterSuffix?: string;
    readonly id?: string;
    readonly topicArn: string;
}
export declare class S3BucketNotification extends TerraformResource {
    constructor(scope: Construct, id: string, config: S3BucketNotificationConfig);
    private _bucket;
    get bucket(): string;
    set bucket(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _lambdaFunction?;
    get lambdaFunction(): S3BucketNotificationLambdaFunction[] | undefined;
    set lambdaFunction(value: S3BucketNotificationLambdaFunction[] | undefined);
    private _queue?;
    get queue(): S3BucketNotificationQueue[] | undefined;
    set queue(value: S3BucketNotificationQueue[] | undefined);
    private _topic?;
    get topic(): S3BucketNotificationTopic[] | undefined;
    set topic(value: S3BucketNotificationTopic[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
