import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface S3BucketObjectConfig extends TerraformMetaArguments {
    readonly acl?: string;
    readonly bucket: string;
    readonly cacheControl?: string;
    readonly content?: string;
    readonly contentBase64?: string;
    readonly contentDisposition?: string;
    readonly contentEncoding?: string;
    readonly contentLanguage?: string;
    readonly contentType?: string;
    readonly etag?: string;
    readonly forceDestroy?: boolean;
    readonly key: string;
    readonly kmsKeyId?: string;
    readonly metadata?: {
        [key: string]: string;
    };
    readonly objectLockLegalHoldStatus?: string;
    readonly objectLockMode?: string;
    readonly objectLockRetainUntilDate?: string;
    readonly serverSideEncryption?: string;
    readonly source?: string;
    readonly storageClass?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly websiteRedirect?: string;
}
export declare class S3BucketObject extends TerraformResource {
    constructor(scope: Construct, id: string, config: S3BucketObjectConfig);
    private _acl?;
    get acl(): string | undefined;
    set acl(value: string | undefined);
    private _bucket;
    get bucket(): string;
    set bucket(value: string);
    private _cacheControl?;
    get cacheControl(): string | undefined;
    set cacheControl(value: string | undefined);
    private _content?;
    get content(): string | undefined;
    set content(value: string | undefined);
    private _contentBase64?;
    get contentBase64(): string | undefined;
    set contentBase64(value: string | undefined);
    private _contentDisposition?;
    get contentDisposition(): string | undefined;
    set contentDisposition(value: string | undefined);
    private _contentEncoding?;
    get contentEncoding(): string | undefined;
    set contentEncoding(value: string | undefined);
    private _contentLanguage?;
    get contentLanguage(): string | undefined;
    set contentLanguage(value: string | undefined);
    private _contentType?;
    get contentType(): string | undefined;
    set contentType(value: string | undefined);
    private _etag?;
    get etag(): string | undefined;
    set etag(value: string | undefined);
    private _forceDestroy?;
    get forceDestroy(): boolean | undefined;
    set forceDestroy(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _key;
    get key(): string;
    set key(value: string);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    } | undefined;
    set metadata(value: {
        [key: string]: string;
    } | undefined);
    private _objectLockLegalHoldStatus?;
    get objectLockLegalHoldStatus(): string | undefined;
    set objectLockLegalHoldStatus(value: string | undefined);
    private _objectLockMode?;
    get objectLockMode(): string | undefined;
    set objectLockMode(value: string | undefined);
    private _objectLockRetainUntilDate?;
    get objectLockRetainUntilDate(): string | undefined;
    set objectLockRetainUntilDate(value: string | undefined);
    private _serverSideEncryption?;
    get serverSideEncryption(): string | undefined;
    set serverSideEncryption(value: string | undefined);
    private _source?;
    get source(): string | undefined;
    set source(value: string | undefined);
    private _storageClass?;
    get storageClass(): string | undefined;
    set storageClass(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get versionId(): string;
    private _websiteRedirect?;
    get websiteRedirect(): string | undefined;
    set websiteRedirect(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
