import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface S3BucketPublicAccessBlockConfig extends TerraformMetaArguments {
    readonly blockPublicAcls?: boolean;
    readonly blockPublicPolicy?: boolean;
    readonly bucket: string;
    readonly ignorePublicAcls?: boolean;
    readonly restrictPublicBuckets?: boolean;
}
export declare class S3BucketPublicAccessBlock extends TerraformResource {
    constructor(scope: Construct, id: string, config: S3BucketPublicAccessBlockConfig);
    private _blockPublicAcls?;
    get blockPublicAcls(): boolean | undefined;
    set blockPublicAcls(value: boolean | undefined);
    private _blockPublicPolicy?;
    get blockPublicPolicy(): boolean | undefined;
    set blockPublicPolicy(value: boolean | undefined);
    private _bucket;
    get bucket(): string;
    set bucket(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ignorePublicAcls?;
    get ignorePublicAcls(): boolean | undefined;
    set ignorePublicAcls(value: boolean | undefined);
    private _restrictPublicBuckets?;
    get restrictPublicBuckets(): boolean | undefined;
    set restrictPublicBuckets(value: boolean | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
