"use strict";
// https://www.terraform.io/docs/providers/aws/r/s3_bucket_public_access_block.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3BucketPublicAccessBlock = void 0;
const cdktf_1 = require("cdktf");
// Resource
class S3BucketPublicAccessBlock extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_s3_bucket_public_access_block',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._blockPublicAcls = config.blockPublicAcls;
        this._blockPublicPolicy = config.blockPublicPolicy;
        this._bucket = config.bucket;
        this._ignorePublicAcls = config.ignorePublicAcls;
        this._restrictPublicBuckets = config.restrictPublicBuckets;
    }
    get blockPublicAcls() {
        return this._blockPublicAcls;
    }
    set blockPublicAcls(value) {
        this._blockPublicAcls = value;
    }
    get blockPublicPolicy() {
        return this._blockPublicPolicy;
    }
    set blockPublicPolicy(value) {
        this._blockPublicPolicy = value;
    }
    get bucket() {
        return this._bucket;
    }
    set bucket(value) {
        this._bucket = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get ignorePublicAcls() {
        return this._ignorePublicAcls;
    }
    set ignorePublicAcls(value) {
        this._ignorePublicAcls = value;
    }
    get restrictPublicBuckets() {
        return this._restrictPublicBuckets;
    }
    set restrictPublicBuckets(value) {
        this._restrictPublicBuckets = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            block_public_acls: this._blockPublicAcls,
            block_public_policy: this._blockPublicPolicy,
            bucket: this._bucket,
            ignore_public_acls: this._ignorePublicAcls,
            restrict_public_buckets: this._restrictPublicBuckets,
        };
    }
}
exports.S3BucketPublicAccessBlock = S3BucketPublicAccessBlock;
//# sourceMappingURL=data:application/json;base64,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