import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface S3BucketConfig extends TerraformMetaArguments {
    readonly accelerationStatus?: string;
    readonly acl?: string;
    readonly bucket?: string;
    readonly bucketPrefix?: string;
    readonly forceDestroy?: boolean;
    readonly hostedZoneId?: string;
    readonly policy?: string;
    readonly region?: string;
    readonly requestPayer?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly websiteDomain?: string;
    readonly websiteEndpoint?: string;
    /** cors_rule block */
    readonly corsRule?: S3BucketCorsRule[];
    /** grant block */
    readonly grant?: S3BucketGrant[];
    /** lifecycle_rule block */
    readonly lifecycleRule?: S3BucketLifecycleRule[];
    /** logging block */
    readonly logging?: S3BucketLogging[];
    /** object_lock_configuration block */
    readonly objectLockConfiguration?: S3BucketObjectLockConfiguration[];
    /** replication_configuration block */
    readonly replicationConfiguration?: S3BucketReplicationConfiguration[];
    /** server_side_encryption_configuration block */
    readonly serverSideEncryptionConfiguration?: S3BucketServerSideEncryptionConfiguration[];
    /** versioning block */
    readonly versioning?: S3BucketVersioning[];
    /** website block */
    readonly website?: S3BucketWebsite[];
}
export interface S3BucketCorsRule {
    readonly allowedHeaders?: string[];
    readonly allowedMethods: string[];
    readonly allowedOrigins: string[];
    readonly exposeHeaders?: string[];
    readonly maxAgeSeconds?: number;
}
export interface S3BucketGrant {
    readonly id?: string;
    readonly permissions: string[];
    readonly type: string;
    readonly uri?: string;
}
export interface S3BucketLifecycleRuleExpiration {
    readonly date?: string;
    readonly days?: number;
    readonly expiredObjectDeleteMarker?: boolean;
}
export interface S3BucketLifecycleRuleNoncurrentVersionExpiration {
    readonly days?: number;
}
export interface S3BucketLifecycleRuleNoncurrentVersionTransition {
    readonly days?: number;
    readonly storageClass: string;
}
export interface S3BucketLifecycleRuleTransition {
    readonly date?: string;
    readonly days?: number;
    readonly storageClass: string;
}
export interface S3BucketLifecycleRule {
    readonly abortIncompleteMultipartUploadDays?: number;
    readonly enabled: boolean;
    readonly id?: string;
    readonly prefix?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** expiration block */
    readonly expiration?: S3BucketLifecycleRuleExpiration[];
    /** noncurrent_version_expiration block */
    readonly noncurrentVersionExpiration?: S3BucketLifecycleRuleNoncurrentVersionExpiration[];
    /** noncurrent_version_transition block */
    readonly noncurrentVersionTransition?: S3BucketLifecycleRuleNoncurrentVersionTransition[];
    /** transition block */
    readonly transition?: S3BucketLifecycleRuleTransition[];
}
export interface S3BucketLogging {
    readonly targetBucket: string;
    readonly targetPrefix?: string;
}
export interface S3BucketObjectLockConfigurationRuleDefaultRetention {
    readonly days?: number;
    readonly mode: string;
    readonly years?: number;
}
export interface S3BucketObjectLockConfigurationRule {
    /** default_retention block */
    readonly defaultRetention: S3BucketObjectLockConfigurationRuleDefaultRetention[];
}
export interface S3BucketObjectLockConfiguration {
    readonly objectLockEnabled: string;
    /** rule block */
    readonly rule?: S3BucketObjectLockConfigurationRule[];
}
export interface S3BucketReplicationConfigurationRulesDestinationAccessControlTranslation {
    readonly owner: string;
}
export interface S3BucketReplicationConfigurationRulesDestination {
    readonly accountId?: string;
    readonly bucket: string;
    readonly replicaKmsKeyId?: string;
    readonly storageClass?: string;
    /** access_control_translation block */
    readonly accessControlTranslation?: S3BucketReplicationConfigurationRulesDestinationAccessControlTranslation[];
}
export interface S3BucketReplicationConfigurationRulesFilter {
    readonly prefix?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export interface S3BucketReplicationConfigurationRulesSourceSelectionCriteriaSseKmsEncryptedObjects {
    readonly enabled: boolean;
}
export interface S3BucketReplicationConfigurationRulesSourceSelectionCriteria {
    /** sse_kms_encrypted_objects block */
    readonly sseKmsEncryptedObjects?: S3BucketReplicationConfigurationRulesSourceSelectionCriteriaSseKmsEncryptedObjects[];
}
export interface S3BucketReplicationConfigurationRules {
    readonly id?: string;
    readonly prefix?: string;
    readonly priority?: number;
    readonly status: string;
    /** destination block */
    readonly destination: S3BucketReplicationConfigurationRulesDestination[];
    /** filter block */
    readonly filter?: S3BucketReplicationConfigurationRulesFilter[];
    /** source_selection_criteria block */
    readonly sourceSelectionCriteria?: S3BucketReplicationConfigurationRulesSourceSelectionCriteria[];
}
export interface S3BucketReplicationConfiguration {
    readonly role: string;
    /** rules block */
    readonly rules: S3BucketReplicationConfigurationRules[];
}
export interface S3BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault {
    readonly kmsMasterKeyId?: string;
    readonly sseAlgorithm: string;
}
export interface S3BucketServerSideEncryptionConfigurationRule {
    /** apply_server_side_encryption_by_default block */
    readonly applyServerSideEncryptionByDefault: S3BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault[];
}
export interface S3BucketServerSideEncryptionConfiguration {
    /** rule block */
    readonly rule: S3BucketServerSideEncryptionConfigurationRule[];
}
export interface S3BucketVersioning {
    readonly enabled?: boolean;
    readonly mfaDelete?: boolean;
}
export interface S3BucketWebsite {
    readonly errorDocument?: string;
    readonly indexDocument?: string;
    readonly redirectAllRequestsTo?: string;
    readonly routingRules?: string;
}
export declare class S3Bucket extends TerraformResource {
    constructor(scope: Construct, id: string, config?: S3BucketConfig);
    private _accelerationStatus?;
    get accelerationStatus(): string | undefined;
    set accelerationStatus(value: string | undefined);
    private _acl?;
    get acl(): string | undefined;
    set acl(value: string | undefined);
    private _arn?;
    get arn(): string | undefined;
    set arn(value: string | undefined);
    private _bucket?;
    get bucket(): string | undefined;
    set bucket(value: string | undefined);
    get bucketDomainName(): string;
    private _bucketPrefix?;
    get bucketPrefix(): string | undefined;
    set bucketPrefix(value: string | undefined);
    get bucketRegionalDomainName(): string;
    private _forceDestroy?;
    get forceDestroy(): boolean | undefined;
    set forceDestroy(value: boolean | undefined);
    private _hostedZoneId?;
    get hostedZoneId(): string | undefined;
    set hostedZoneId(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _policy?;
    get policy(): string | undefined;
    set policy(value: string | undefined);
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    private _requestPayer?;
    get requestPayer(): string | undefined;
    set requestPayer(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _websiteDomain?;
    get websiteDomain(): string | undefined;
    set websiteDomain(value: string | undefined);
    private _websiteEndpoint?;
    get websiteEndpoint(): string | undefined;
    set websiteEndpoint(value: string | undefined);
    private _corsRule?;
    get corsRule(): S3BucketCorsRule[] | undefined;
    set corsRule(value: S3BucketCorsRule[] | undefined);
    private _grant?;
    get grant(): S3BucketGrant[] | undefined;
    set grant(value: S3BucketGrant[] | undefined);
    private _lifecycleRule?;
    get lifecycleRule(): S3BucketLifecycleRule[] | undefined;
    set lifecycleRule(value: S3BucketLifecycleRule[] | undefined);
    private _logging?;
    get logging(): S3BucketLogging[] | undefined;
    set logging(value: S3BucketLogging[] | undefined);
    private _objectLockConfiguration?;
    get objectLockConfiguration(): S3BucketObjectLockConfiguration[] | undefined;
    set objectLockConfiguration(value: S3BucketObjectLockConfiguration[] | undefined);
    private _replicationConfiguration?;
    get replicationConfiguration(): S3BucketReplicationConfiguration[] | undefined;
    set replicationConfiguration(value: S3BucketReplicationConfiguration[] | undefined);
    private _serverSideEncryptionConfiguration?;
    get serverSideEncryptionConfiguration(): S3BucketServerSideEncryptionConfiguration[] | undefined;
    set serverSideEncryptionConfiguration(value: S3BucketServerSideEncryptionConfiguration[] | undefined);
    private _versioning?;
    get versioning(): S3BucketVersioning[] | undefined;
    set versioning(value: S3BucketVersioning[] | undefined);
    private _website?;
    get website(): S3BucketWebsite[] | undefined;
    set website(value: S3BucketWebsite[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
