"use strict";
// https://www.terraform.io/docs/providers/aws/r/s3_bucket.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3Bucket = void 0;
const cdktf_1 = require("cdktf");
// Resource
class S3Bucket extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws_s3_bucket',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._accelerationStatus = config.accelerationStatus;
        this._acl = config.acl;
        this._bucket = config.bucket;
        this._bucketPrefix = config.bucketPrefix;
        this._forceDestroy = config.forceDestroy;
        this._hostedZoneId = config.hostedZoneId;
        this._policy = config.policy;
        this._region = config.region;
        this._requestPayer = config.requestPayer;
        this._tags = config.tags;
        this._websiteDomain = config.websiteDomain;
        this._websiteEndpoint = config.websiteEndpoint;
        this._corsRule = config.corsRule;
        this._grant = config.grant;
        this._lifecycleRule = config.lifecycleRule;
        this._logging = config.logging;
        this._objectLockConfiguration = config.objectLockConfiguration;
        this._replicationConfiguration = config.replicationConfiguration;
        this._serverSideEncryptionConfiguration = config.serverSideEncryptionConfiguration;
        this._versioning = config.versioning;
        this._website = config.website;
    }
    get accelerationStatus() {
        var _a;
        return (_a = this._accelerationStatus) !== null && _a !== void 0 ? _a : this.getStringAttribute('acceleration_status');
    }
    set accelerationStatus(value) {
        this._accelerationStatus = value;
    }
    get acl() {
        return this._acl;
    }
    set acl(value) {
        this._acl = value;
    }
    get arn() {
        var _a;
        return (_a = this._arn) !== null && _a !== void 0 ? _a : this.getStringAttribute('arn');
    }
    set arn(value) {
        this._arn = value;
    }
    get bucket() {
        var _a;
        return (_a = this._bucket) !== null && _a !== void 0 ? _a : this.getStringAttribute('bucket');
    }
    set bucket(value) {
        this._bucket = value;
    }
    // bucket_domain_name - computed: true, optional: false, required: true
    get bucketDomainName() {
        return this.getStringAttribute('bucket_domain_name');
    }
    get bucketPrefix() {
        return this._bucketPrefix;
    }
    set bucketPrefix(value) {
        this._bucketPrefix = value;
    }
    // bucket_regional_domain_name - computed: true, optional: false, required: true
    get bucketRegionalDomainName() {
        return this.getStringAttribute('bucket_regional_domain_name');
    }
    get forceDestroy() {
        return this._forceDestroy;
    }
    set forceDestroy(value) {
        this._forceDestroy = value;
    }
    get hostedZoneId() {
        var _a;
        return (_a = this._hostedZoneId) !== null && _a !== void 0 ? _a : this.getStringAttribute('hosted_zone_id');
    }
    set hostedZoneId(value) {
        this._hostedZoneId = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get policy() {
        return this._policy;
    }
    set policy(value) {
        this._policy = value;
    }
    get region() {
        var _a;
        return (_a = this._region) !== null && _a !== void 0 ? _a : this.getStringAttribute('region');
    }
    set region(value) {
        this._region = value;
    }
    get requestPayer() {
        var _a;
        return (_a = this._requestPayer) !== null && _a !== void 0 ? _a : this.getStringAttribute('request_payer');
    }
    set requestPayer(value) {
        this._requestPayer = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get websiteDomain() {
        var _a;
        return (_a = this._websiteDomain) !== null && _a !== void 0 ? _a : this.getStringAttribute('website_domain');
    }
    set websiteDomain(value) {
        this._websiteDomain = value;
    }
    get websiteEndpoint() {
        var _a;
        return (_a = this._websiteEndpoint) !== null && _a !== void 0 ? _a : this.getStringAttribute('website_endpoint');
    }
    set websiteEndpoint(value) {
        this._websiteEndpoint = value;
    }
    get corsRule() {
        return this._corsRule;
    }
    set corsRule(value) {
        this._corsRule = value;
    }
    get grant() {
        return this._grant;
    }
    set grant(value) {
        this._grant = value;
    }
    get lifecycleRule() {
        return this._lifecycleRule;
    }
    set lifecycleRule(value) {
        this._lifecycleRule = value;
    }
    get logging() {
        return this._logging;
    }
    set logging(value) {
        this._logging = value;
    }
    get objectLockConfiguration() {
        return this._objectLockConfiguration;
    }
    set objectLockConfiguration(value) {
        this._objectLockConfiguration = value;
    }
    get replicationConfiguration() {
        return this._replicationConfiguration;
    }
    set replicationConfiguration(value) {
        this._replicationConfiguration = value;
    }
    get serverSideEncryptionConfiguration() {
        return this._serverSideEncryptionConfiguration;
    }
    set serverSideEncryptionConfiguration(value) {
        this._serverSideEncryptionConfiguration = value;
    }
    get versioning() {
        return this._versioning;
    }
    set versioning(value) {
        this._versioning = value;
    }
    get website() {
        return this._website;
    }
    set website(value) {
        this._website = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            acceleration_status: this._accelerationStatus,
            acl: this._acl,
            bucket: this._bucket,
            bucket_prefix: this._bucketPrefix,
            force_destroy: this._forceDestroy,
            hosted_zone_id: this._hostedZoneId,
            policy: this._policy,
            region: this._region,
            request_payer: this._requestPayer,
            tags: this._tags,
            website_domain: this._websiteDomain,
            website_endpoint: this._websiteEndpoint,
            cors_rule: this._corsRule,
            grant: this._grant,
            lifecycle_rule: this._lifecycleRule,
            logging: this._logging,
            object_lock_configuration: this._objectLockConfiguration,
            replication_configuration: this._replicationConfiguration,
            server_side_encryption_configuration: this._serverSideEncryptionConfiguration,
            versioning: this._versioning,
            website: this._website,
        };
    }
}
exports.S3Bucket = S3Bucket;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiczMtYnVja2V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3MzLWJ1Y2tldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsK0RBQStEO0FBQy9ELDJDQUEyQzs7O0FBd2YzQyxpQ0FBMEM7QUFrSzFDLFdBQVc7QUFFWCxNQUFhLFFBQVMsU0FBUSx5QkFBaUI7SUFFN0MsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjO0lBRWQsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsU0FBeUIsRUFBRTtRQUMxRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLHFCQUFxQixFQUFFLGVBQWU7WUFDdEMsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxLQUFLO2FBQ3BCO1lBQ0QsUUFBUSxFQUFFLE1BQU0sQ0FBQyxRQUFRO1lBQ3pCLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixLQUFLLEVBQUUsTUFBTSxDQUFDLEtBQUs7WUFDbkIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1NBQzVCLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxtQkFBbUIsR0FBRyxNQUFNLENBQUMsa0JBQWtCLENBQUM7UUFDckQsSUFBSSxDQUFDLElBQUksR0FBRyxNQUFNLENBQUMsR0FBRyxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQztRQUM3QixJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxZQUFZLENBQUM7UUFDekMsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLFlBQVksQ0FBQztRQUN6QyxJQUFJLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUM7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDO1FBQzdCLElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLFlBQVksQ0FBQztRQUN6QyxJQUFJLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDekIsSUFBSSxDQUFDLGNBQWMsR0FBRyxNQUFNLENBQUMsYUFBYSxDQUFDO1FBQzNDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxNQUFNLENBQUMsZUFBZSxDQUFDO1FBQy9DLElBQUksQ0FBQyxTQUFTLEdBQUcsTUFBTSxDQUFDLFFBQVEsQ0FBQztRQUNqQyxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFDM0IsSUFBSSxDQUFDLGNBQWMsR0FBRyxNQUFNLENBQUMsYUFBYSxDQUFDO1FBQzNDLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUMvQixJQUFJLENBQUMsd0JBQXdCLEdBQUcsTUFBTSxDQUFDLHVCQUF1QixDQUFDO1FBQy9ELElBQUksQ0FBQyx5QkFBeUIsR0FBRyxNQUFNLENBQUMsd0JBQXdCLENBQUM7UUFDakUsSUFBSSxDQUFDLGtDQUFrQyxHQUFHLE1BQU0sQ0FBQyxpQ0FBaUMsQ0FBQztRQUNuRixJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7UUFDckMsSUFBSSxDQUFDLFFBQVEsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDO0lBQ2pDLENBQUM7SUFRRCxJQUFXLGtCQUFrQjs7UUFDM0IsYUFBTyxJQUFJLENBQUMsbUJBQW1CLG1DQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3BGLENBQUM7SUFDRCxJQUFXLGtCQUFrQixDQUFDLEtBQXlCO1FBQ3JELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUM7SUFDbkMsQ0FBQztJQUlELElBQVcsR0FBRztRQUNaLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQztJQUNuQixDQUFDO0lBQ0QsSUFBVyxHQUFHLENBQUMsS0FBeUI7UUFDdEMsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUlELElBQVcsR0FBRzs7UUFDWixhQUFPLElBQUksQ0FBQyxJQUFJLG1DQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBQ0QsSUFBVyxHQUFHLENBQUMsS0FBeUI7UUFDdEMsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUlELElBQVcsTUFBTTs7UUFDZixhQUFPLElBQUksQ0FBQyxPQUFPLG1DQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMzRCxDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBeUI7UUFDekMsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUVELHVFQUF1RTtJQUN2RSxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZELENBQUM7SUFJRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFDRCxJQUFXLFlBQVksQ0FBQyxLQUF5QjtRQUMvQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBRUQsZ0ZBQWdGO0lBQ2hGLElBQVcsd0JBQXdCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDaEUsQ0FBQztJQUlELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUM7SUFDNUIsQ0FBQztJQUNELElBQVcsWUFBWSxDQUFDLEtBQTBCO1FBQ2hELElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzdCLENBQUM7SUFJRCxJQUFXLFlBQVk7O1FBQ3JCLGFBQU8sSUFBSSxDQUFDLGFBQWEsbUNBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDekUsQ0FBQztJQUNELElBQVcsWUFBWSxDQUFDLEtBQXlCO1FBQy9DLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzdCLENBQUM7SUFJRCxJQUFXLEVBQUU7O1FBQ1gsYUFBTyxJQUFJLENBQUMsR0FBRyxtQ0FBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQXlCO1FBQ3JDLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDO0lBQ25CLENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUNELElBQVcsTUFBTSxDQUFDLEtBQXlCO1FBQ3pDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFJRCxJQUFXLE1BQU07O1FBQ2YsYUFBTyxJQUFJLENBQUMsT0FBTyxtQ0FBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0QsQ0FBQztJQUNELElBQVcsTUFBTSxDQUFDLEtBQXlCO1FBQ3pDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFJRCxJQUFXLFlBQVk7O1FBQ3JCLGFBQU8sSUFBSSxDQUFDLGFBQWEsbUNBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ3hFLENBQUM7SUFDRCxJQUFXLFlBQVksQ0FBQyxLQUF5QjtRQUMvQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUE0QztRQUMxRCxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBSUQsSUFBVyxhQUFhOztRQUN0QixhQUFPLElBQUksQ0FBQyxjQUFjLG1DQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQzFFLENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUF5QjtRQUNoRCxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztJQUM5QixDQUFDO0lBSUQsSUFBVyxlQUFlOztRQUN4QixhQUFPLElBQUksQ0FBQyxnQkFBZ0IsbUNBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDOUUsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQXlCO1FBQ2xELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUM7SUFDaEMsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUNELElBQVcsUUFBUSxDQUFDLEtBQXFDO1FBQ3ZELElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFJRCxJQUFXLEtBQUs7UUFDZCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDckIsQ0FBQztJQUNELElBQVcsS0FBSyxDQUFDLEtBQWtDO1FBQ2pELElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDO0lBQ3RCLENBQUM7SUFJRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUEwQztRQUNqRSxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztJQUM5QixDQUFDO0lBSUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBb0M7UUFDckQsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7SUFDeEIsQ0FBQztJQUlELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLHdCQUF3QixDQUFDO0lBQ3ZDLENBQUM7SUFDRCxJQUFXLHVCQUF1QixDQUFDLEtBQW9EO1FBQ3JGLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxLQUFLLENBQUM7SUFDeEMsQ0FBQztJQUlELElBQVcsd0JBQXdCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLHlCQUF5QixDQUFDO0lBQ3hDLENBQUM7SUFDRCxJQUFXLHdCQUF3QixDQUFDLEtBQXFEO1FBQ3ZGLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxLQUFLLENBQUM7SUFDekMsQ0FBQztJQUlELElBQVcsaUNBQWlDO1FBQzFDLE9BQU8sSUFBSSxDQUFDLGtDQUFrQyxDQUFDO0lBQ2pELENBQUM7SUFDRCxJQUFXLGlDQUFpQyxDQUFDLEtBQThEO1FBQ3pHLElBQUksQ0FBQyxrQ0FBa0MsR0FBRyxLQUFLLENBQUM7SUFDbEQsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUNELElBQVcsVUFBVSxDQUFDLEtBQXVDO1FBQzNELElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFJRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFDRCxJQUFXLE9BQU8sQ0FBQyxLQUFvQztRQUNyRCxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZO0lBRUwsb0JBQW9CO1FBQ3pCLE9BQU87WUFDTCxtQkFBbUIsRUFBRSxJQUFJLENBQUMsbUJBQW1CO1lBQzdDLEdBQUcsRUFBRSxJQUFJLENBQUMsSUFBSTtZQUNkLE1BQU0sRUFBRSxJQUFJLENBQUMsT0FBTztZQUNwQixhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWE7WUFDakMsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhO1lBQ2pDLGNBQWMsRUFBRSxJQUFJLENBQUMsYUFBYTtZQUNsQyxNQUFNLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDcEIsTUFBTSxFQUFFLElBQUksQ0FBQyxPQUFPO1lBQ3BCLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTtZQUNqQyxJQUFJLEVBQUUsSUFBSSxDQUFDLEtBQUs7WUFDaEIsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO1lBQ25DLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7WUFDdkMsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLEtBQUssRUFBRSxJQUFJLENBQUMsTUFBTTtZQUNsQixjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsT0FBTyxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3RCLHlCQUF5QixFQUFFLElBQUksQ0FBQyx3QkFBd0I7WUFDeEQseUJBQXlCLEVBQUUsSUFBSSxDQUFDLHlCQUF5QjtZQUN6RCxvQ0FBb0MsRUFBRSxJQUFJLENBQUMsa0NBQWtDO1lBQzdFLFVBQVUsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM1QixPQUFPLEVBQUUsSUFBSSxDQUFDLFFBQVE7U0FDdkIsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQWxTRCw0QkFrU0MiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXdzL3IvczNfYnVja2V0Lmh0bWxcbi8vIGdlbmVyYXRlZCBmcm9tIHRlcnJhZm9ybSByZXNvdXJjZSBzY2hlbWFcblxuLypcbntcbiAgXCJ2ZXJzaW9uXCI6IDAsXG4gIFwiYmxvY2tcIjoge1xuICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICBcImFjY2VsZXJhdGlvbl9zdGF0dXNcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImFjbFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImFyblwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiYnVja2V0XCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZSxcbiAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJidWNrZXRfZG9tYWluX25hbWVcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJidWNrZXRfcHJlZml4XCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiYnVja2V0X3JlZ2lvbmFsX2RvbWFpbl9uYW1lXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiZm9yY2VfZGVzdHJveVwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcImJvb2xcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJob3N0ZWRfem9uZV9pZFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiaWRcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInBvbGljeVwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInJlZ2lvblwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwicmVxdWVzdF9wYXllclwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwidGFnc1wiOiB7XG4gICAgICAgIFwidHlwZVwiOiBbXG4gICAgICAgICAgXCJtYXBcIixcbiAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgIF0sXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwid2Vic2l0ZV9kb21haW5cIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcIndlYnNpdGVfZW5kcG9pbnRcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH1cbiAgICB9LFxuICAgIFwiYmxvY2tfdHlwZXNcIjoge1xuICAgICAgXCJjb3JzX3J1bGVcIjoge1xuICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgIFwiYWxsb3dlZF9oZWFkZXJzXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFtcbiAgICAgICAgICAgICAgICBcImxpc3RcIixcbiAgICAgICAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwiYWxsb3dlZF9tZXRob2RzXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFtcbiAgICAgICAgICAgICAgICBcImxpc3RcIixcbiAgICAgICAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwiYWxsb3dlZF9vcmlnaW5zXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFtcbiAgICAgICAgICAgICAgICBcImxpc3RcIixcbiAgICAgICAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwiZXhwb3NlX2hlYWRlcnNcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogW1xuICAgICAgICAgICAgICAgIFwibGlzdFwiLFxuICAgICAgICAgICAgICAgIFwic3RyaW5nXCJcbiAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJtYXhfYWdlX3NlY29uZHNcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJudW1iZXJcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9LFxuICAgICAgXCJncmFudFwiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwic2V0XCIsXG4gICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICBcImlkXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwicGVybWlzc2lvbnNcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogW1xuICAgICAgICAgICAgICAgIFwic2V0XCIsXG4gICAgICAgICAgICAgICAgXCJzdHJpbmdcIlxuICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInR5cGVcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJ1cmlcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9LFxuICAgICAgXCJsaWZlY3ljbGVfcnVsZVwiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgXCJhYm9ydF9pbmNvbXBsZXRlX211bHRpcGFydF91cGxvYWRfZGF5c1wiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcIm51bWJlclwiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcImVuYWJsZWRcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJib29sXCIsXG4gICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwiaWRcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInByZWZpeFwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInRhZ3NcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogW1xuICAgICAgICAgICAgICAgIFwibWFwXCIsXG4gICAgICAgICAgICAgICAgXCJzdHJpbmdcIlxuICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9LFxuICAgICAgICAgIFwiYmxvY2tfdHlwZXNcIjoge1xuICAgICAgICAgICAgXCJleHBpcmF0aW9uXCI6IHtcbiAgICAgICAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICBcImRhdGVcIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgXCJkYXlzXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwibnVtYmVyXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwiZXhwaXJlZF9vYmplY3RfZGVsZXRlX21hcmtlclwiOiB7XG4gICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcImJvb2xcIixcbiAgICAgICAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJub25jdXJyZW50X3ZlcnNpb25fZXhwaXJhdGlvblwiOiB7XG4gICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgICAgICAgXCJkYXlzXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwibnVtYmVyXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgXCJtYXhfaXRlbXNcIjogMVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwibm9uY3VycmVudF92ZXJzaW9uX3RyYW5zaXRpb25cIjoge1xuICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcInNldFwiLFxuICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgICAgICAgXCJkYXlzXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwibnVtYmVyXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwic3RvcmFnZV9jbGFzc1wiOiB7XG4gICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInRyYW5zaXRpb25cIjoge1xuICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcInNldFwiLFxuICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgICAgICAgXCJkYXRlXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwiZGF5c1wiOiB7XG4gICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcIm51bWJlclwiLFxuICAgICAgICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICBcInN0b3JhZ2VfY2xhc3NcIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9LFxuICAgICAgXCJsb2dnaW5nXCI6IHtcbiAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJzZXRcIixcbiAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgIFwidGFyZ2V0X2J1Y2tldFwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInRhcmdldF9wcmVmaXhcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9LFxuICAgICAgXCJvYmplY3RfbG9ja19jb25maWd1cmF0aW9uXCI6IHtcbiAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICBcIm9iamVjdF9sb2NrX2VuYWJsZWRcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfSxcbiAgICAgICAgICBcImJsb2NrX3R5cGVzXCI6IHtcbiAgICAgICAgICAgIFwicnVsZVwiOiB7XG4gICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICBcImJsb2NrX3R5cGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgIFwiZGVmYXVsdF9yZXRlbnRpb25cIjoge1xuICAgICAgICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIFwiZGF5c1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcIm51bWJlclwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICBcIm1vZGVcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgXCJ5ZWFyc1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcIm51bWJlclwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIFwibWluX2l0ZW1zXCI6IDEsXG4gICAgICAgICAgICAgICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgIH0sXG4gICAgICBcInJlcGxpY2F0aW9uX2NvbmZpZ3VyYXRpb25cIjoge1xuICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgIFwicm9sZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9LFxuICAgICAgICAgIFwiYmxvY2tfdHlwZXNcIjoge1xuICAgICAgICAgICAgXCJydWxlc1wiOiB7XG4gICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwic2V0XCIsXG4gICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICBcImlkXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwicHJlZml4XCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwicHJpb3JpdHlcIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJudW1iZXJcIixcbiAgICAgICAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgXCJzdGF0dXNcIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICBcImJsb2NrX3R5cGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgIFwiZGVzdGluYXRpb25cIjoge1xuICAgICAgICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIFwiYWNjb3VudF9pZFwiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICBcImJ1Y2tldFwiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICBcInJlcGxpY2Ffa21zX2tleV9pZFwiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VfY2xhc3NcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICBcImJsb2NrX3R5cGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIFwiYWNjZXNzX2NvbnRyb2xfdHJhbnNsYXRpb25cIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwib3duZXJcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICBcIm1pbl9pdGVtc1wiOiAxLFxuICAgICAgICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgXCJmaWx0ZXJcIjoge1xuICAgICAgICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIFwicHJlZml4XCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIFwidGFnc1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBbXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJtYXBcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgICAgICAgICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgXCJtYXhfaXRlbXNcIjogMVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwic291cmNlX3NlbGVjdGlvbl9jcml0ZXJpYVwiOiB7XG4gICAgICAgICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICBcImJsb2NrX3R5cGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIFwic3NlX2ttc19lbmNyeXB0ZWRfb2JqZWN0c1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJlbmFibGVkXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwiYm9vbFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIFwibWluX2l0ZW1zXCI6IDFcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgIH0sXG4gICAgICBcInNlcnZlcl9zaWRlX2VuY3J5cHRpb25fY29uZmlndXJhdGlvblwiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImJsb2NrX3R5cGVzXCI6IHtcbiAgICAgICAgICAgIFwicnVsZVwiOiB7XG4gICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICBcImJsb2NrX3R5cGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgIFwiYXBwbHlfc2VydmVyX3NpZGVfZW5jcnlwdGlvbl9ieV9kZWZhdWx0XCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBcImttc19tYXN0ZXJfa2V5X2lkXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIFwic3NlX2FsZ29yaXRobVwiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIFwibWluX2l0ZW1zXCI6IDEsXG4gICAgICAgICAgICAgICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIFwibWluX2l0ZW1zXCI6IDEsXG4gICAgICAgICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgIH0sXG4gICAgICBcInZlcnNpb25pbmdcIjoge1xuICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgIFwiZW5hYmxlZFwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcImJvb2xcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJtZmFfZGVsZXRlXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwiYm9vbFwiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgIH0sXG4gICAgICBcIndlYnNpdGVcIjoge1xuICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgIFwiZXJyb3JfZG9jdW1lbnRcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJpbmRleF9kb2N1bWVudFwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInJlZGlyZWN0X2FsbF9yZXF1ZXN0c190b1wiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInJvdXRpbmdfcnVsZXNcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9LFxuICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICB9XG4gICAgfVxuICB9XG59XG4qL1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBUZXJyYWZvcm1SZXNvdXJjZSB9IGZyb20gJ2Nka3RmJztcbmltcG9ydCB7IFRlcnJhZm9ybU1ldGFBcmd1bWVudHMgfSBmcm9tICdjZGt0Zic7XG5cbi8vIENvbmZpZ3VyYXRpb25cblxuZXhwb3J0IGludGVyZmFjZSBTM0J1Y2tldENvbmZpZyBleHRlbmRzIFRlcnJhZm9ybU1ldGFBcmd1bWVudHMge1xuICByZWFkb25seSBhY2NlbGVyYXRpb25TdGF0dXM/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGFjbD86IHN0cmluZztcbiAgcmVhZG9ubHkgYnVja2V0Pzogc3RyaW5nO1xuICByZWFkb25seSBidWNrZXRQcmVmaXg/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGZvcmNlRGVzdHJveT86IGJvb2xlYW47XG4gIHJlYWRvbmx5IGhvc3RlZFpvbmVJZD86IHN0cmluZztcbiAgcmVhZG9ubHkgcG9saWN5Pzogc3RyaW5nO1xuICByZWFkb25seSByZWdpb24/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJlcXVlc3RQYXllcj86IHN0cmluZztcbiAgcmVhZG9ubHkgdGFncz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG4gIHJlYWRvbmx5IHdlYnNpdGVEb21haW4/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHdlYnNpdGVFbmRwb2ludD86IHN0cmluZztcbiAgLyoqIGNvcnNfcnVsZSBibG9jayAqL1xuICByZWFkb25seSBjb3JzUnVsZT86IFMzQnVja2V0Q29yc1J1bGVbXTtcbiAgLyoqIGdyYW50IGJsb2NrICovXG4gIHJlYWRvbmx5IGdyYW50PzogUzNCdWNrZXRHcmFudFtdO1xuICAvKiogbGlmZWN5Y2xlX3J1bGUgYmxvY2sgKi9cbiAgcmVhZG9ubHkgbGlmZWN5Y2xlUnVsZT86IFMzQnVja2V0TGlmZWN5Y2xlUnVsZVtdO1xuICAvKiogbG9nZ2luZyBibG9jayAqL1xuICByZWFkb25seSBsb2dnaW5nPzogUzNCdWNrZXRMb2dnaW5nW107XG4gIC8qKiBvYmplY3RfbG9ja19jb25maWd1cmF0aW9uIGJsb2NrICovXG4gIHJlYWRvbmx5IG9iamVjdExvY2tDb25maWd1cmF0aW9uPzogUzNCdWNrZXRPYmplY3RMb2NrQ29uZmlndXJhdGlvbltdO1xuICAvKiogcmVwbGljYXRpb25fY29uZmlndXJhdGlvbiBibG9jayAqL1xuICByZWFkb25seSByZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb24/OiBTM0J1Y2tldFJlcGxpY2F0aW9uQ29uZmlndXJhdGlvbltdO1xuICAvKiogc2VydmVyX3NpZGVfZW5jcnlwdGlvbl9jb25maWd1cmF0aW9uIGJsb2NrICovXG4gIHJlYWRvbmx5IHNlcnZlclNpZGVFbmNyeXB0aW9uQ29uZmlndXJhdGlvbj86IFMzQnVja2V0U2VydmVyU2lkZUVuY3J5cHRpb25Db25maWd1cmF0aW9uW107XG4gIC8qKiB2ZXJzaW9uaW5nIGJsb2NrICovXG4gIHJlYWRvbmx5IHZlcnNpb25pbmc/OiBTM0J1Y2tldFZlcnNpb25pbmdbXTtcbiAgLyoqIHdlYnNpdGUgYmxvY2sgKi9cbiAgcmVhZG9ubHkgd2Vic2l0ZT86IFMzQnVja2V0V2Vic2l0ZVtdO1xufVxuZXhwb3J0IGludGVyZmFjZSBTM0J1Y2tldENvcnNSdWxlIHtcbiAgcmVhZG9ubHkgYWxsb3dlZEhlYWRlcnM/OiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgYWxsb3dlZE1ldGhvZHM6IHN0cmluZ1tdO1xuICByZWFkb25seSBhbGxvd2VkT3JpZ2luczogc3RyaW5nW107XG4gIHJlYWRvbmx5IGV4cG9zZUhlYWRlcnM/OiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgbWF4QWdlU2Vjb25kcz86IG51bWJlcjtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgUzNCdWNrZXRHcmFudCB7XG4gIHJlYWRvbmx5IGlkPzogc3RyaW5nO1xuICByZWFkb25seSBwZXJtaXNzaW9uczogc3RyaW5nW107XG4gIHJlYWRvbmx5IHR5cGU6IHN0cmluZztcbiAgcmVhZG9ubHkgdXJpPzogc3RyaW5nO1xufVxuZXhwb3J0IGludGVyZmFjZSBTM0J1Y2tldExpZmVjeWNsZVJ1bGVFeHBpcmF0aW9uIHtcbiAgcmVhZG9ubHkgZGF0ZT86IHN0cmluZztcbiAgcmVhZG9ubHkgZGF5cz86IG51bWJlcjtcbiAgcmVhZG9ubHkgZXhwaXJlZE9iamVjdERlbGV0ZU1hcmtlcj86IGJvb2xlYW47XG59XG5leHBvcnQgaW50ZXJmYWNlIFMzQnVja2V0TGlmZWN5Y2xlUnVsZU5vbmN1cnJlbnRWZXJzaW9uRXhwaXJhdGlvbiB7XG4gIHJlYWRvbmx5IGRheXM/OiBudW1iZXI7XG59XG5leHBvcnQgaW50ZXJmYWNlIFMzQnVja2V0TGlmZWN5Y2xlUnVsZU5vbmN1cnJlbnRWZXJzaW9uVHJhbnNpdGlvbiB7XG4gIHJlYWRvbmx5IGRheXM/OiBudW1iZXI7XG4gIHJlYWRvbmx5IHN0b3JhZ2VDbGFzczogc3RyaW5nO1xufVxuZXhwb3J0IGludGVyZmFjZSBTM0J1Y2tldExpZmVjeWNsZVJ1bGVUcmFuc2l0aW9uIHtcbiAgcmVhZG9ubHkgZGF0ZT86IHN0cmluZztcbiAgcmVhZG9ubHkgZGF5cz86IG51bWJlcjtcbiAgcmVhZG9ubHkgc3RvcmFnZUNsYXNzOiBzdHJpbmc7XG59XG5leHBvcnQgaW50ZXJmYWNlIFMzQnVja2V0TGlmZWN5Y2xlUnVsZSB7XG4gIHJlYWRvbmx5IGFib3J0SW5jb21wbGV0ZU11bHRpcGFydFVwbG9hZERheXM/OiBudW1iZXI7XG4gIHJlYWRvbmx5IGVuYWJsZWQ6IGJvb2xlYW47XG4gIHJlYWRvbmx5IGlkPzogc3RyaW5nO1xuICByZWFkb25seSBwcmVmaXg/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHRhZ3M/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9O1xuICAvKiogZXhwaXJhdGlvbiBibG9jayAqL1xuICByZWFkb25seSBleHBpcmF0aW9uPzogUzNCdWNrZXRMaWZlY3ljbGVSdWxlRXhwaXJhdGlvbltdO1xuICAvKiogbm9uY3VycmVudF92ZXJzaW9uX2V4cGlyYXRpb24gYmxvY2sgKi9cbiAgcmVhZG9ubHkgbm9uY3VycmVudFZlcnNpb25FeHBpcmF0aW9uPzogUzNCdWNrZXRMaWZlY3ljbGVSdWxlTm9uY3VycmVudFZlcnNpb25FeHBpcmF0aW9uW107XG4gIC8qKiBub25jdXJyZW50X3ZlcnNpb25fdHJhbnNpdGlvbiBibG9jayAqL1xuICByZWFkb25seSBub25jdXJyZW50VmVyc2lvblRyYW5zaXRpb24/OiBTM0J1Y2tldExpZmVjeWNsZVJ1bGVOb25jdXJyZW50VmVyc2lvblRyYW5zaXRpb25bXTtcbiAgLyoqIHRyYW5zaXRpb24gYmxvY2sgKi9cbiAgcmVhZG9ubHkgdHJhbnNpdGlvbj86IFMzQnVja2V0TGlmZWN5Y2xlUnVsZVRyYW5zaXRpb25bXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgUzNCdWNrZXRMb2dnaW5nIHtcbiAgcmVhZG9ubHkgdGFyZ2V0QnVja2V0OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHRhcmdldFByZWZpeD86IHN0cmluZztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgUzNCdWNrZXRPYmplY3RMb2NrQ29uZmlndXJhdGlvblJ1bGVEZWZhdWx0UmV0ZW50aW9uIHtcbiAgcmVhZG9ubHkgZGF5cz86IG51bWJlcjtcbiAgcmVhZG9ubHkgbW9kZTogc3RyaW5nO1xuICByZWFkb25seSB5ZWFycz86IG51bWJlcjtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgUzNCdWNrZXRPYmplY3RMb2NrQ29uZmlndXJhdGlvblJ1bGUge1xuICAvKiogZGVmYXVsdF9yZXRlbnRpb24gYmxvY2sgKi9cbiAgcmVhZG9ubHkgZGVmYXVsdFJldGVudGlvbjogUzNCdWNrZXRPYmplY3RMb2NrQ29uZmlndXJhdGlvblJ1bGVEZWZhdWx0UmV0ZW50aW9uW107XG59XG5leHBvcnQgaW50ZXJmYWNlIFMzQnVja2V0T2JqZWN0TG9ja0NvbmZpZ3VyYXRpb24ge1xuICByZWFkb25seSBvYmplY3RMb2NrRW5hYmxlZDogc3RyaW5nO1xuICAvKiogcnVsZSBibG9jayAqL1xuICByZWFkb25seSBydWxlPzogUzNCdWNrZXRPYmplY3RMb2NrQ29uZmlndXJhdGlvblJ1bGVbXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgUzNCdWNrZXRSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25SdWxlc0Rlc3RpbmF0aW9uQWNjZXNzQ29udHJvbFRyYW5zbGF0aW9uIHtcbiAgcmVhZG9ubHkgb3duZXI6IHN0cmluZztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgUzNCdWNrZXRSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25SdWxlc0Rlc3RpbmF0aW9uIHtcbiAgcmVhZG9ubHkgYWNjb3VudElkPzogc3RyaW5nO1xuICByZWFkb25seSBidWNrZXQ6IHN0cmluZztcbiAgcmVhZG9ubHkgcmVwbGljYUttc0tleUlkPzogc3RyaW5nO1xuICByZWFkb25seSBzdG9yYWdlQ2xhc3M/OiBzdHJpbmc7XG4gIC8qKiBhY2Nlc3NfY29udHJvbF90cmFuc2xhdGlvbiBibG9jayAqL1xuICByZWFkb25seSBhY2Nlc3NDb250cm9sVHJhbnNsYXRpb24/OiBTM0J1Y2tldFJlcGxpY2F0aW9uQ29uZmlndXJhdGlvblJ1bGVzRGVzdGluYXRpb25BY2Nlc3NDb250cm9sVHJhbnNsYXRpb25bXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgUzNCdWNrZXRSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25SdWxlc0ZpbHRlciB7XG4gIHJlYWRvbmx5IHByZWZpeD86IHN0cmluZztcbiAgcmVhZG9ubHkgdGFncz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG59XG5leHBvcnQgaW50ZXJmYWNlIFMzQnVja2V0UmVwbGljYXRpb25Db25maWd1cmF0aW9uUnVsZXNTb3VyY2VTZWxlY3Rpb25Dcml0ZXJpYVNzZUttc0VuY3J5cHRlZE9iamVjdHMge1xuICByZWFkb25seSBlbmFibGVkOiBib29sZWFuO1xufVxuZXhwb3J0IGludGVyZmFjZSBTM0J1Y2tldFJlcGxpY2F0aW9uQ29uZmlndXJhdGlvblJ1bGVzU291cmNlU2VsZWN0aW9uQ3JpdGVyaWEge1xuICAvKiogc3NlX2ttc19lbmNyeXB0ZWRfb2JqZWN0cyBibG9jayAqL1xuICByZWFkb25seSBzc2VLbXNFbmNyeXB0ZWRPYmplY3RzPzogUzNCdWNrZXRSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25SdWxlc1NvdXJjZVNlbGVjdGlvbkNyaXRlcmlhU3NlS21zRW5jcnlwdGVkT2JqZWN0c1tdO1xufVxuZXhwb3J0IGludGVyZmFjZSBTM0J1Y2tldFJlcGxpY2F0aW9uQ29uZmlndXJhdGlvblJ1bGVzIHtcbiAgcmVhZG9ubHkgaWQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHByZWZpeD86IHN0cmluZztcbiAgcmVhZG9ubHkgcHJpb3JpdHk/OiBudW1iZXI7XG4gIHJlYWRvbmx5IHN0YXR1czogc3RyaW5nO1xuICAvKiogZGVzdGluYXRpb24gYmxvY2sgKi9cbiAgcmVhZG9ubHkgZGVzdGluYXRpb246IFMzQnVja2V0UmVwbGljYXRpb25Db25maWd1cmF0aW9uUnVsZXNEZXN0aW5hdGlvbltdO1xuICAvKiogZmlsdGVyIGJsb2NrICovXG4gIHJlYWRvbmx5IGZpbHRlcj86IFMzQnVja2V0UmVwbGljYXRpb25Db25maWd1cmF0aW9uUnVsZXNGaWx0ZXJbXTtcbiAgLyoqIHNvdXJjZV9zZWxlY3Rpb25fY3JpdGVyaWEgYmxvY2sgKi9cbiAgcmVhZG9ubHkgc291cmNlU2VsZWN0aW9uQ3JpdGVyaWE/OiBTM0J1Y2tldFJlcGxpY2F0aW9uQ29uZmlndXJhdGlvblJ1bGVzU291cmNlU2VsZWN0aW9uQ3JpdGVyaWFbXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgUzNCdWNrZXRSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb24ge1xuICByZWFkb25seSByb2xlOiBzdHJpbmc7XG4gIC8qKiBydWxlcyBibG9jayAqL1xuICByZWFkb25seSBydWxlczogUzNCdWNrZXRSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25SdWxlc1tdO1xufVxuZXhwb3J0IGludGVyZmFjZSBTM0J1Y2tldFNlcnZlclNpZGVFbmNyeXB0aW9uQ29uZmlndXJhdGlvblJ1bGVBcHBseVNlcnZlclNpZGVFbmNyeXB0aW9uQnlEZWZhdWx0IHtcbiAgcmVhZG9ubHkga21zTWFzdGVyS2V5SWQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNzZUFsZ29yaXRobTogc3RyaW5nO1xufVxuZXhwb3J0IGludGVyZmFjZSBTM0J1Y2tldFNlcnZlclNpZGVFbmNyeXB0aW9uQ29uZmlndXJhdGlvblJ1bGUge1xuICAvKiogYXBwbHlfc2VydmVyX3NpZGVfZW5jcnlwdGlvbl9ieV9kZWZhdWx0IGJsb2NrICovXG4gIHJlYWRvbmx5IGFwcGx5U2VydmVyU2lkZUVuY3J5cHRpb25CeURlZmF1bHQ6IFMzQnVja2V0U2VydmVyU2lkZUVuY3J5cHRpb25Db25maWd1cmF0aW9uUnVsZUFwcGx5U2VydmVyU2lkZUVuY3J5cHRpb25CeURlZmF1bHRbXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgUzNCdWNrZXRTZXJ2ZXJTaWRlRW5jcnlwdGlvbkNvbmZpZ3VyYXRpb24ge1xuICAvKiogcnVsZSBibG9jayAqL1xuICByZWFkb25seSBydWxlOiBTM0J1Y2tldFNlcnZlclNpZGVFbmNyeXB0aW9uQ29uZmlndXJhdGlvblJ1bGVbXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgUzNCdWNrZXRWZXJzaW9uaW5nIHtcbiAgcmVhZG9ubHkgZW5hYmxlZD86IGJvb2xlYW47XG4gIHJlYWRvbmx5IG1mYURlbGV0ZT86IGJvb2xlYW47XG59XG5leHBvcnQgaW50ZXJmYWNlIFMzQnVja2V0V2Vic2l0ZSB7XG4gIHJlYWRvbmx5IGVycm9yRG9jdW1lbnQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGluZGV4RG9jdW1lbnQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJlZGlyZWN0QWxsUmVxdWVzdHNUbz86IHN0cmluZztcbiAgcmVhZG9ubHkgcm91dGluZ1J1bGVzPzogc3RyaW5nO1xufVxuXG4vLyBSZXNvdXJjZVxuXG5leHBvcnQgY2xhc3MgUzNCdWNrZXQgZXh0ZW5kcyBUZXJyYWZvcm1SZXNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBTM0J1Y2tldENvbmZpZyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdhd3NfczNfYnVja2V0JyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2F3cydcbiAgICAgIH0sXG4gICAgICBwcm92aWRlcjogY29uZmlnLnByb3ZpZGVyLFxuICAgICAgZGVwZW5kc09uOiBjb25maWcuZGVwZW5kc09uLFxuICAgICAgY291bnQ6IGNvbmZpZy5jb3VudCxcbiAgICAgIGxpZmVjeWNsZTogY29uZmlnLmxpZmVjeWNsZVxuICAgIH0pO1xuICAgIHRoaXMuX2FjY2VsZXJhdGlvblN0YXR1cyA9IGNvbmZpZy5hY2NlbGVyYXRpb25TdGF0dXM7XG4gICAgdGhpcy5fYWNsID0gY29uZmlnLmFjbDtcbiAgICB0aGlzLl9idWNrZXQgPSBjb25maWcuYnVja2V0O1xuICAgIHRoaXMuX2J1Y2tldFByZWZpeCA9IGNvbmZpZy5idWNrZXRQcmVmaXg7XG4gICAgdGhpcy5fZm9yY2VEZXN0cm95ID0gY29uZmlnLmZvcmNlRGVzdHJveTtcbiAgICB0aGlzLl9ob3N0ZWRab25lSWQgPSBjb25maWcuaG9zdGVkWm9uZUlkO1xuICAgIHRoaXMuX3BvbGljeSA9IGNvbmZpZy5wb2xpY3k7XG4gICAgdGhpcy5fcmVnaW9uID0gY29uZmlnLnJlZ2lvbjtcbiAgICB0aGlzLl9yZXF1ZXN0UGF5ZXIgPSBjb25maWcucmVxdWVzdFBheWVyO1xuICAgIHRoaXMuX3RhZ3MgPSBjb25maWcudGFncztcbiAgICB0aGlzLl93ZWJzaXRlRG9tYWluID0gY29uZmlnLndlYnNpdGVEb21haW47XG4gICAgdGhpcy5fd2Vic2l0ZUVuZHBvaW50ID0gY29uZmlnLndlYnNpdGVFbmRwb2ludDtcbiAgICB0aGlzLl9jb3JzUnVsZSA9IGNvbmZpZy5jb3JzUnVsZTtcbiAgICB0aGlzLl9ncmFudCA9IGNvbmZpZy5ncmFudDtcbiAgICB0aGlzLl9saWZlY3ljbGVSdWxlID0gY29uZmlnLmxpZmVjeWNsZVJ1bGU7XG4gICAgdGhpcy5fbG9nZ2luZyA9IGNvbmZpZy5sb2dnaW5nO1xuICAgIHRoaXMuX29iamVjdExvY2tDb25maWd1cmF0aW9uID0gY29uZmlnLm9iamVjdExvY2tDb25maWd1cmF0aW9uO1xuICAgIHRoaXMuX3JlcGxpY2F0aW9uQ29uZmlndXJhdGlvbiA9IGNvbmZpZy5yZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb247XG4gICAgdGhpcy5fc2VydmVyU2lkZUVuY3J5cHRpb25Db25maWd1cmF0aW9uID0gY29uZmlnLnNlcnZlclNpZGVFbmNyeXB0aW9uQ29uZmlndXJhdGlvbjtcbiAgICB0aGlzLl92ZXJzaW9uaW5nID0gY29uZmlnLnZlcnNpb25pbmc7XG4gICAgdGhpcy5fd2Vic2l0ZSA9IGNvbmZpZy53ZWJzaXRlO1xuICB9XG5cbiAgLy8gPT09PT09PT09PVxuICAvLyBBVFRSSUJVVEVTXG4gIC8vID09PT09PT09PT1cblxuICAvLyBhY2NlbGVyYXRpb25fc3RhdHVzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYWNjZWxlcmF0aW9uU3RhdHVzPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGFjY2VsZXJhdGlvblN0YXR1cygpIHtcbiAgICByZXR1cm4gdGhpcy5fYWNjZWxlcmF0aW9uU3RhdHVzID8/IHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdhY2NlbGVyYXRpb25fc3RhdHVzJyk7XG4gIH1cbiAgcHVibGljIHNldCBhY2NlbGVyYXRpb25TdGF0dXModmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2FjY2VsZXJhdGlvblN0YXR1cyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gYWNsIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2FjbD86IHN0cmluZztcbiAgcHVibGljIGdldCBhY2woKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FjbDtcbiAgfVxuICBwdWJsaWMgc2V0IGFjbCh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fYWNsID0gdmFsdWU7XG4gIH1cblxuICAvLyBhcm4gLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hcm4/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgYXJuKCkge1xuICAgIHJldHVybiB0aGlzLl9hcm4gPz8gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2FybicpO1xuICB9XG4gIHB1YmxpYyBzZXQgYXJuKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9hcm4gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGJ1Y2tldCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2J1Y2tldD86IHN0cmluZztcbiAgcHVibGljIGdldCBidWNrZXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2J1Y2tldCA/PyB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnYnVja2V0Jyk7XG4gIH1cbiAgcHVibGljIHNldCBidWNrZXQodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2J1Y2tldCA9IHZhbHVlO1xuICB9XG5cbiAgLy8gYnVja2V0X2RvbWFpbl9uYW1lIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHVibGljIGdldCBidWNrZXREb21haW5OYW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnYnVja2V0X2RvbWFpbl9uYW1lJyk7XG4gIH1cblxuICAvLyBidWNrZXRfcHJlZml4IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2J1Y2tldFByZWZpeD86IHN0cmluZztcbiAgcHVibGljIGdldCBidWNrZXRQcmVmaXgoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2J1Y2tldFByZWZpeDtcbiAgfVxuICBwdWJsaWMgc2V0IGJ1Y2tldFByZWZpeCh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fYnVja2V0UHJlZml4ID0gdmFsdWU7XG4gIH1cblxuICAvLyBidWNrZXRfcmVnaW9uYWxfZG9tYWluX25hbWUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwdWJsaWMgZ2V0IGJ1Y2tldFJlZ2lvbmFsRG9tYWluTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2J1Y2tldF9yZWdpb25hbF9kb21haW5fbmFtZScpO1xuICB9XG5cbiAgLy8gZm9yY2VfZGVzdHJveSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9mb3JjZURlc3Ryb3k/OiBib29sZWFuO1xuICBwdWJsaWMgZ2V0IGZvcmNlRGVzdHJveSgpIHtcbiAgICByZXR1cm4gdGhpcy5fZm9yY2VEZXN0cm95O1xuICB9XG4gIHB1YmxpYyBzZXQgZm9yY2VEZXN0cm95KHZhbHVlOiBib29sZWFuIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fZm9yY2VEZXN0cm95ID0gdmFsdWU7XG4gIH1cblxuICAvLyBob3N0ZWRfem9uZV9pZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2hvc3RlZFpvbmVJZD86IHN0cmluZztcbiAgcHVibGljIGdldCBob3N0ZWRab25lSWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2hvc3RlZFpvbmVJZCA/PyB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaG9zdGVkX3pvbmVfaWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGhvc3RlZFpvbmVJZCh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5faG9zdGVkWm9uZUlkID0gdmFsdWU7XG4gIH1cblxuICAvLyBpZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2lkPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGlkKCkge1xuICAgIHJldHVybiB0aGlzLl9pZCA/PyB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGlkKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9pZCA9IHZhbHVlO1xuICB9XG5cbiAgLy8gcG9saWN5IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3BvbGljeT86IHN0cmluZztcbiAgcHVibGljIGdldCBwb2xpY3koKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BvbGljeTtcbiAgfVxuICBwdWJsaWMgc2V0IHBvbGljeSh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fcG9saWN5ID0gdmFsdWU7XG4gIH1cblxuICAvLyByZWdpb24gLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9yZWdpb24/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgcmVnaW9uKCkge1xuICAgIHJldHVybiB0aGlzLl9yZWdpb24gPz8gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3JlZ2lvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVnaW9uKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9yZWdpb24gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHJlcXVlc3RfcGF5ZXIgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9yZXF1ZXN0UGF5ZXI/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgcmVxdWVzdFBheWVyKCkge1xuICAgIHJldHVybiB0aGlzLl9yZXF1ZXN0UGF5ZXIgPz8gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3JlcXVlc3RfcGF5ZXInKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJlcXVlc3RQYXllcih2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fcmVxdWVzdFBheWVyID0gdmFsdWU7XG4gIH1cblxuICAvLyB0YWdzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3RhZ3M/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9O1xuICBwdWJsaWMgZ2V0IHRhZ3MoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RhZ3M7XG4gIH1cbiAgcHVibGljIHNldCB0YWdzKHZhbHVlOiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9IHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fdGFncyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gd2Vic2l0ZV9kb21haW4gLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF93ZWJzaXRlRG9tYWluPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IHdlYnNpdGVEb21haW4oKSB7XG4gICAgcmV0dXJuIHRoaXMuX3dlYnNpdGVEb21haW4gPz8gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3dlYnNpdGVfZG9tYWluJyk7XG4gIH1cbiAgcHVibGljIHNldCB3ZWJzaXRlRG9tYWluKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl93ZWJzaXRlRG9tYWluID0gdmFsdWU7XG4gIH1cblxuICAvLyB3ZWJzaXRlX2VuZHBvaW50IC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfd2Vic2l0ZUVuZHBvaW50Pzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IHdlYnNpdGVFbmRwb2ludCgpIHtcbiAgICByZXR1cm4gdGhpcy5fd2Vic2l0ZUVuZHBvaW50ID8/IHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd3ZWJzaXRlX2VuZHBvaW50Jyk7XG4gIH1cbiAgcHVibGljIHNldCB3ZWJzaXRlRW5kcG9pbnQodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3dlYnNpdGVFbmRwb2ludCA9IHZhbHVlO1xuICB9XG5cbiAgLy8gY29yc19ydWxlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NvcnNSdWxlPzogUzNCdWNrZXRDb3JzUnVsZVtdO1xuICBwdWJsaWMgZ2V0IGNvcnNSdWxlKCkge1xuICAgIHJldHVybiB0aGlzLl9jb3JzUnVsZTtcbiAgfVxuICBwdWJsaWMgc2V0IGNvcnNSdWxlKHZhbHVlOiBTM0J1Y2tldENvcnNSdWxlW10gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9jb3JzUnVsZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gZ3JhbnQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZ3JhbnQ/OiBTM0J1Y2tldEdyYW50W107XG4gIHB1YmxpYyBnZXQgZ3JhbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2dyYW50O1xuICB9XG4gIHB1YmxpYyBzZXQgZ3JhbnQodmFsdWU6IFMzQnVja2V0R3JhbnRbXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2dyYW50ID0gdmFsdWU7XG4gIH1cblxuICAvLyBsaWZlY3ljbGVfcnVsZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9saWZlY3ljbGVSdWxlPzogUzNCdWNrZXRMaWZlY3ljbGVSdWxlW107XG4gIHB1YmxpYyBnZXQgbGlmZWN5Y2xlUnVsZSgpIHtcbiAgICByZXR1cm4gdGhpcy5fbGlmZWN5Y2xlUnVsZTtcbiAgfVxuICBwdWJsaWMgc2V0IGxpZmVjeWNsZVJ1bGUodmFsdWU6IFMzQnVja2V0TGlmZWN5Y2xlUnVsZVtdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fbGlmZWN5Y2xlUnVsZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gbG9nZ2luZyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9sb2dnaW5nPzogUzNCdWNrZXRMb2dnaW5nW107XG4gIHB1YmxpYyBnZXQgbG9nZ2luZygpIHtcbiAgICByZXR1cm4gdGhpcy5fbG9nZ2luZztcbiAgfVxuICBwdWJsaWMgc2V0IGxvZ2dpbmcodmFsdWU6IFMzQnVja2V0TG9nZ2luZ1tdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fbG9nZ2luZyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gb2JqZWN0X2xvY2tfY29uZmlndXJhdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9vYmplY3RMb2NrQ29uZmlndXJhdGlvbj86IFMzQnVja2V0T2JqZWN0TG9ja0NvbmZpZ3VyYXRpb25bXTtcbiAgcHVibGljIGdldCBvYmplY3RMb2NrQ29uZmlndXJhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5fb2JqZWN0TG9ja0NvbmZpZ3VyYXRpb247XG4gIH1cbiAgcHVibGljIHNldCBvYmplY3RMb2NrQ29uZmlndXJhdGlvbih2YWx1ZTogUzNCdWNrZXRPYmplY3RMb2NrQ29uZmlndXJhdGlvbltdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fb2JqZWN0TG9ja0NvbmZpZ3VyYXRpb24gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHJlcGxpY2F0aW9uX2NvbmZpZ3VyYXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVwbGljYXRpb25Db25maWd1cmF0aW9uPzogUzNCdWNrZXRSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25bXTtcbiAgcHVibGljIGdldCByZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlcGxpY2F0aW9uQ29uZmlndXJhdGlvbjtcbiAgfVxuICBwdWJsaWMgc2V0IHJlcGxpY2F0aW9uQ29uZmlndXJhdGlvbih2YWx1ZTogUzNCdWNrZXRSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25bXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3JlcGxpY2F0aW9uQ29uZmlndXJhdGlvbiA9IHZhbHVlO1xuICB9XG5cbiAgLy8gc2VydmVyX3NpZGVfZW5jcnlwdGlvbl9jb25maWd1cmF0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NlcnZlclNpZGVFbmNyeXB0aW9uQ29uZmlndXJhdGlvbj86IFMzQnVja2V0U2VydmVyU2lkZUVuY3J5cHRpb25Db25maWd1cmF0aW9uW107XG4gIHB1YmxpYyBnZXQgc2VydmVyU2lkZUVuY3J5cHRpb25Db25maWd1cmF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLl9zZXJ2ZXJTaWRlRW5jcnlwdGlvbkNvbmZpZ3VyYXRpb247XG4gIH1cbiAgcHVibGljIHNldCBzZXJ2ZXJTaWRlRW5jcnlwdGlvbkNvbmZpZ3VyYXRpb24odmFsdWU6IFMzQnVja2V0U2VydmVyU2lkZUVuY3J5cHRpb25Db25maWd1cmF0aW9uW10gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9zZXJ2ZXJTaWRlRW5jcnlwdGlvbkNvbmZpZ3VyYXRpb24gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHZlcnNpb25pbmcgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdmVyc2lvbmluZz86IFMzQnVja2V0VmVyc2lvbmluZ1tdO1xuICBwdWJsaWMgZ2V0IHZlcnNpb25pbmcoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3ZlcnNpb25pbmc7XG4gIH1cbiAgcHVibGljIHNldCB2ZXJzaW9uaW5nKHZhbHVlOiBTM0J1Y2tldFZlcnNpb25pbmdbXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3ZlcnNpb25pbmcgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHdlYnNpdGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfd2Vic2l0ZT86IFMzQnVja2V0V2Vic2l0ZVtdO1xuICBwdWJsaWMgZ2V0IHdlYnNpdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3dlYnNpdGU7XG4gIH1cbiAgcHVibGljIHNldCB3ZWJzaXRlKHZhbHVlOiBTM0J1Y2tldFdlYnNpdGVbXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3dlYnNpdGUgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vID09PT09PT09PVxuICAvLyBTWU5USEVTSVNcbiAgLy8gPT09PT09PT09XG5cbiAgcHVibGljIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ge1xuICAgICAgYWNjZWxlcmF0aW9uX3N0YXR1czogdGhpcy5fYWNjZWxlcmF0aW9uU3RhdHVzLFxuICAgICAgYWNsOiB0aGlzLl9hY2wsXG4gICAgICBidWNrZXQ6IHRoaXMuX2J1Y2tldCxcbiAgICAgIGJ1Y2tldF9wcmVmaXg6IHRoaXMuX2J1Y2tldFByZWZpeCxcbiAgICAgIGZvcmNlX2Rlc3Ryb3k6IHRoaXMuX2ZvcmNlRGVzdHJveSxcbiAgICAgIGhvc3RlZF96b25lX2lkOiB0aGlzLl9ob3N0ZWRab25lSWQsXG4gICAgICBwb2xpY3k6IHRoaXMuX3BvbGljeSxcbiAgICAgIHJlZ2lvbjogdGhpcy5fcmVnaW9uLFxuICAgICAgcmVxdWVzdF9wYXllcjogdGhpcy5fcmVxdWVzdFBheWVyLFxuICAgICAgdGFnczogdGhpcy5fdGFncyxcbiAgICAgIHdlYnNpdGVfZG9tYWluOiB0aGlzLl93ZWJzaXRlRG9tYWluLFxuICAgICAgd2Vic2l0ZV9lbmRwb2ludDogdGhpcy5fd2Vic2l0ZUVuZHBvaW50LFxuICAgICAgY29yc19ydWxlOiB0aGlzLl9jb3JzUnVsZSxcbiAgICAgIGdyYW50OiB0aGlzLl9ncmFudCxcbiAgICAgIGxpZmVjeWNsZV9ydWxlOiB0aGlzLl9saWZlY3ljbGVSdWxlLFxuICAgICAgbG9nZ2luZzogdGhpcy5fbG9nZ2luZyxcbiAgICAgIG9iamVjdF9sb2NrX2NvbmZpZ3VyYXRpb246IHRoaXMuX29iamVjdExvY2tDb25maWd1cmF0aW9uLFxuICAgICAgcmVwbGljYXRpb25fY29uZmlndXJhdGlvbjogdGhpcy5fcmVwbGljYXRpb25Db25maWd1cmF0aW9uLFxuICAgICAgc2VydmVyX3NpZGVfZW5jcnlwdGlvbl9jb25maWd1cmF0aW9uOiB0aGlzLl9zZXJ2ZXJTaWRlRW5jcnlwdGlvbkNvbmZpZ3VyYXRpb24sXG4gICAgICB2ZXJzaW9uaW5nOiB0aGlzLl92ZXJzaW9uaW5nLFxuICAgICAgd2Vic2l0ZTogdGhpcy5fd2Vic2l0ZSxcbiAgICB9O1xuICB9XG59XG4iXX0=