import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SagemakerEndpointConfigurationConfig extends TerraformMetaArguments {
    readonly kmsKeyArn?: string;
    readonly name?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** production_variants block */
    readonly productionVariants: SagemakerEndpointConfigurationProductionVariants[];
}
export interface SagemakerEndpointConfigurationProductionVariants {
    readonly acceleratorType?: string;
    readonly initialInstanceCount: number;
    readonly initialVariantWeight?: number;
    readonly instanceType: string;
    readonly modelName: string;
    readonly variantName?: string;
}
export declare class SagemakerEndpointConfiguration extends TerraformResource {
    constructor(scope: Construct, id: string, config: SagemakerEndpointConfigurationConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyArn?;
    get kmsKeyArn(): string | undefined;
    set kmsKeyArn(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _productionVariants;
    get productionVariants(): SagemakerEndpointConfigurationProductionVariants[];
    set productionVariants(value: SagemakerEndpointConfigurationProductionVariants[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
