import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SagemakerEndpointConfig extends TerraformMetaArguments {
    readonly endpointConfigName: string;
    readonly name?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class SagemakerEndpoint extends TerraformResource {
    constructor(scope: Construct, id: string, config: SagemakerEndpointConfig);
    get arn(): string;
    private _endpointConfigName;
    get endpointConfigName(): string;
    set endpointConfigName(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
