import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SagemakerModelConfig extends TerraformMetaArguments {
    readonly enableNetworkIsolation?: boolean;
    readonly executionRoleArn: string;
    readonly name?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** container block */
    readonly container?: SagemakerModelContainer[];
    /** primary_container block */
    readonly primaryContainer?: SagemakerModelPrimaryContainer[];
    /** vpc_config block */
    readonly vpcConfig?: SagemakerModelVpcConfig[];
}
export interface SagemakerModelContainer {
    readonly containerHostname?: string;
    readonly environment?: {
        [key: string]: string;
    };
    readonly image: string;
    readonly modelDataUrl?: string;
}
export interface SagemakerModelPrimaryContainer {
    readonly containerHostname?: string;
    readonly environment?: {
        [key: string]: string;
    };
    readonly image: string;
    readonly modelDataUrl?: string;
}
export interface SagemakerModelVpcConfig {
    readonly securityGroupIds: string[];
    readonly subnets: string[];
}
export declare class SagemakerModel extends TerraformResource {
    constructor(scope: Construct, id: string, config: SagemakerModelConfig);
    get arn(): string;
    private _enableNetworkIsolation?;
    get enableNetworkIsolation(): boolean | undefined;
    set enableNetworkIsolation(value: boolean | undefined);
    private _executionRoleArn;
    get executionRoleArn(): string;
    set executionRoleArn(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _container?;
    get container(): SagemakerModelContainer[] | undefined;
    set container(value: SagemakerModelContainer[] | undefined);
    private _primaryContainer?;
    get primaryContainer(): SagemakerModelPrimaryContainer[] | undefined;
    set primaryContainer(value: SagemakerModelPrimaryContainer[] | undefined);
    private _vpcConfig?;
    get vpcConfig(): SagemakerModelVpcConfig[] | undefined;
    set vpcConfig(value: SagemakerModelVpcConfig[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
