"use strict";
// https://www.terraform.io/docs/providers/aws/r/sagemaker_model.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.SagemakerModel = void 0;
const cdktf_1 = require("cdktf");
// Resource
class SagemakerModel extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_sagemaker_model',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._enableNetworkIsolation = config.enableNetworkIsolation;
        this._executionRoleArn = config.executionRoleArn;
        this._name = config.name;
        this._tags = config.tags;
        this._container = config.container;
        this._primaryContainer = config.primaryContainer;
        this._vpcConfig = config.vpcConfig;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get enableNetworkIsolation() {
        return this._enableNetworkIsolation;
    }
    set enableNetworkIsolation(value) {
        this._enableNetworkIsolation = value;
    }
    get executionRoleArn() {
        return this._executionRoleArn;
    }
    set executionRoleArn(value) {
        this._executionRoleArn = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get name() {
        var _a;
        return (_a = this._name) !== null && _a !== void 0 ? _a : this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get container() {
        return this._container;
    }
    set container(value) {
        this._container = value;
    }
    get primaryContainer() {
        return this._primaryContainer;
    }
    set primaryContainer(value) {
        this._primaryContainer = value;
    }
    get vpcConfig() {
        return this._vpcConfig;
    }
    set vpcConfig(value) {
        this._vpcConfig = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            enable_network_isolation: this._enableNetworkIsolation,
            execution_role_arn: this._executionRoleArn,
            name: this._name,
            tags: this._tags,
            container: this._container,
            primary_container: this._primaryContainer,
            vpc_config: this._vpcConfig,
        };
    }
}
exports.SagemakerModel = SagemakerModel;
//# sourceMappingURL=data:application/json;base64,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