import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SagemakerNotebookInstanceConfig extends TerraformMetaArguments {
    readonly directInternetAccess?: string;
    readonly instanceType: string;
    readonly kmsKeyId?: string;
    readonly lifecycleConfigName?: string;
    readonly name: string;
    readonly roleArn: string;
    readonly securityGroups?: string[];
    readonly subnetId?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class SagemakerNotebookInstance extends TerraformResource {
    constructor(scope: Construct, id: string, config: SagemakerNotebookInstanceConfig);
    get arn(): string;
    private _directInternetAccess?;
    get directInternetAccess(): string | undefined;
    set directInternetAccess(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _instanceType;
    get instanceType(): string;
    set instanceType(value: string);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    private _lifecycleConfigName?;
    get lifecycleConfigName(): string | undefined;
    set lifecycleConfigName(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _roleArn;
    get roleArn(): string;
    set roleArn(value: string);
    private _securityGroups?;
    get securityGroups(): string[] | undefined;
    set securityGroups(value: string[] | undefined);
    private _subnetId?;
    get subnetId(): string | undefined;
    set subnetId(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
