import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SecretsmanagerSecretRotationConfig extends TerraformMetaArguments {
    readonly rotationLambdaArn: string;
    readonly secretId: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** rotation_rules block */
    readonly rotationRules: SecretsmanagerSecretRotationRotationRules[];
}
export interface SecretsmanagerSecretRotationRotationRules {
    readonly automaticallyAfterDays: number;
}
export declare class SecretsmanagerSecretRotation extends TerraformResource {
    constructor(scope: Construct, id: string, config: SecretsmanagerSecretRotationConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get rotationEnabled(): boolean;
    private _rotationLambdaArn;
    get rotationLambdaArn(): string;
    set rotationLambdaArn(value: string);
    private _secretId;
    get secretId(): string;
    set secretId(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _rotationRules;
    get rotationRules(): SecretsmanagerSecretRotationRotationRules[];
    set rotationRules(value: SecretsmanagerSecretRotationRotationRules[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
