import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SecretsmanagerSecretConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly kmsKeyId?: string;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly policy?: string;
    readonly recoveryWindowInDays?: number;
    readonly rotationLambdaArn?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** rotation_rules block */
    readonly rotationRules?: SecretsmanagerSecretRotationRules[];
}
export interface SecretsmanagerSecretRotationRules {
    readonly automaticallyAfterDays: number;
}
export declare class SecretsmanagerSecret extends TerraformResource {
    constructor(scope: Construct, id: string, config?: SecretsmanagerSecretConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _policy?;
    get policy(): string | undefined;
    set policy(value: string | undefined);
    private _recoveryWindowInDays?;
    get recoveryWindowInDays(): number | undefined;
    set recoveryWindowInDays(value: number | undefined);
    get rotationEnabled(): boolean;
    private _rotationLambdaArn?;
    get rotationLambdaArn(): string | undefined;
    set rotationLambdaArn(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _rotationRules?;
    get rotationRules(): SecretsmanagerSecretRotationRules[] | undefined;
    set rotationRules(value: SecretsmanagerSecretRotationRules[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
