import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SecurityGroupRuleConfig extends TerraformMetaArguments {
    readonly cidrBlocks?: string[];
    readonly description?: string;
    readonly fromPort: number;
    readonly ipv6CidrBlocks?: string[];
    readonly prefixListIds?: string[];
    readonly protocol: string;
    readonly securityGroupId: string;
    readonly selfAttribute?: boolean;
    readonly sourceSecurityGroupId?: string;
    readonly toPort: number;
    /** Type of rule, ingress (inbound) or egress (outbound). */
    readonly type: string;
}
export declare class SecurityGroupRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: SecurityGroupRuleConfig);
    private _cidrBlocks?;
    get cidrBlocks(): string[] | undefined;
    set cidrBlocks(value: string[] | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _fromPort;
    get fromPort(): number;
    set fromPort(value: number);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ipv6CidrBlocks?;
    get ipv6CidrBlocks(): string[] | undefined;
    set ipv6CidrBlocks(value: string[] | undefined);
    private _prefixListIds?;
    get prefixListIds(): string[] | undefined;
    set prefixListIds(value: string[] | undefined);
    private _protocol;
    get protocol(): string;
    set protocol(value: string);
    private _securityGroupId;
    get securityGroupId(): string;
    set securityGroupId(value: string);
    private _self?;
    get selfAttribute(): boolean | undefined;
    set selfAttribute(value: boolean | undefined);
    private _sourceSecurityGroupId?;
    get sourceSecurityGroupId(): string | undefined;
    set sourceSecurityGroupId(value: string | undefined);
    private _toPort;
    get toPort(): number;
    set toPort(value: number);
    private _type;
    get type(): string;
    set type(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
