import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SecurityGroupConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly egress?: SecurityGroupEgress[];
    readonly ingress?: SecurityGroupIngress[];
    readonly name?: string;
    readonly namePrefix?: string;
    readonly revokeRulesOnDelete?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcId?: string;
    /** timeouts block */
    readonly timeouts?: SecurityGroupTimeouts;
}
export interface SecurityGroupEgress {
    readonly cidrBlocks?: string[];
    readonly description?: string;
    readonly fromPort?: number;
    readonly ipv6CidrBlocks?: string[];
    readonly prefixListIds?: string[];
    readonly protocol?: string;
    readonly securityGroups?: string[];
    readonly selfAttribute?: boolean;
    readonly toPort?: number;
}
export interface SecurityGroupIngress {
    readonly cidrBlocks?: string[];
    readonly description?: string;
    readonly fromPort?: number;
    readonly ipv6CidrBlocks?: string[];
    readonly prefixListIds?: string[];
    readonly protocol?: string;
    readonly securityGroups?: string[];
    readonly selfAttribute?: boolean;
    readonly toPort?: number;
}
export interface SecurityGroupTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class SecurityGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config?: SecurityGroupConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _egress?;
    get egress(): SecurityGroupEgress[] | undefined;
    set egress(value: SecurityGroupEgress[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ingress?;
    get ingress(): SecurityGroupIngress[] | undefined;
    set ingress(value: SecurityGroupIngress[] | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    get ownerId(): string;
    private _revokeRulesOnDelete?;
    get revokeRulesOnDelete(): boolean | undefined;
    set revokeRulesOnDelete(value: boolean | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcId?;
    get vpcId(): string | undefined;
    set vpcId(value: string | undefined);
    private _timeouts?;
    get timeouts(): SecurityGroupTimeouts | undefined;
    set timeouts(value: SecurityGroupTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
