import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SecurityhubMemberConfig extends TerraformMetaArguments {
    readonly accountId: string;
    readonly email: string;
    readonly invite?: boolean;
}
export declare class SecurityhubMember extends TerraformResource {
    constructor(scope: Construct, id: string, config: SecurityhubMemberConfig);
    private _accountId;
    get accountId(): string;
    set accountId(value: string);
    private _email;
    get email(): string;
    set email(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _invite?;
    get invite(): boolean | undefined;
    set invite(value: boolean | undefined);
    get masterId(): string;
    get memberStatus(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
