import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ServiceDiscoveryServiceConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name: string;
    readonly namespaceId?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** dns_config block */
    readonly dnsConfig?: ServiceDiscoveryServiceDnsConfig[];
    /** health_check_config block */
    readonly healthCheckConfig?: ServiceDiscoveryServiceHealthCheckConfig[];
    /** health_check_custom_config block */
    readonly healthCheckCustomConfig?: ServiceDiscoveryServiceHealthCheckCustomConfig[];
}
export interface ServiceDiscoveryServiceDnsConfigDnsRecords {
    readonly ttl: number;
    readonly type: string;
}
export interface ServiceDiscoveryServiceDnsConfig {
    readonly namespaceId: string;
    readonly routingPolicy?: string;
    /** dns_records block */
    readonly dnsRecords: ServiceDiscoveryServiceDnsConfigDnsRecords[];
}
export interface ServiceDiscoveryServiceHealthCheckConfig {
    readonly failureThreshold?: number;
    readonly resourcePath?: string;
    readonly type?: string;
}
export interface ServiceDiscoveryServiceHealthCheckCustomConfig {
    readonly failureThreshold?: number;
}
export declare class ServiceDiscoveryService extends TerraformResource {
    constructor(scope: Construct, id: string, config: ServiceDiscoveryServiceConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _namespaceId?;
    get namespaceId(): string | undefined;
    set namespaceId(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _dnsConfig?;
    get dnsConfig(): ServiceDiscoveryServiceDnsConfig[] | undefined;
    set dnsConfig(value: ServiceDiscoveryServiceDnsConfig[] | undefined);
    private _healthCheckConfig?;
    get healthCheckConfig(): ServiceDiscoveryServiceHealthCheckConfig[] | undefined;
    set healthCheckConfig(value: ServiceDiscoveryServiceHealthCheckConfig[] | undefined);
    private _healthCheckCustomConfig?;
    get healthCheckCustomConfig(): ServiceDiscoveryServiceHealthCheckCustomConfig[] | undefined;
    set healthCheckCustomConfig(value: ServiceDiscoveryServiceHealthCheckCustomConfig[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
