import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ServicecatalogPortfolioConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name: string;
    readonly providerName?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: ServicecatalogPortfolioTimeouts;
}
export interface ServicecatalogPortfolioTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class ServicecatalogPortfolio extends TerraformResource {
    constructor(scope: Construct, id: string, config: ServicecatalogPortfolioConfig);
    get arn(): string;
    get createdTime(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _providerName?;
    get providerName(): string | undefined;
    set providerName(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _timeouts?;
    get timeouts(): ServicecatalogPortfolioTimeouts | undefined;
    set timeouts(value: ServicecatalogPortfolioTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
