"use strict";
// https://www.terraform.io/docs/providers/aws/r/servicequotas_service_quota.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServicequotasServiceQuota = void 0;
const cdktf_1 = require("cdktf");
// Resource
class ServicequotasServiceQuota extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_servicequotas_service_quota',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._quotaCode = config.quotaCode;
        this._serviceCode = config.serviceCode;
        this._value = config.value;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // adjustable - computed: true, optional: false, required: true
    get adjustable() {
        return this.getBooleanAttribute('adjustable');
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    // default_value - computed: true, optional: false, required: true
    get defaultValue() {
        return this.getNumberAttribute('default_value');
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get quotaCode() {
        return this._quotaCode;
    }
    set quotaCode(value) {
        this._quotaCode = value;
    }
    // quota_name - computed: true, optional: false, required: true
    get quotaName() {
        return this.getStringAttribute('quota_name');
    }
    // request_id - computed: true, optional: false, required: true
    get requestId() {
        return this.getStringAttribute('request_id');
    }
    // request_status - computed: true, optional: false, required: true
    get requestStatus() {
        return this.getStringAttribute('request_status');
    }
    get serviceCode() {
        return this._serviceCode;
    }
    set serviceCode(value) {
        this._serviceCode = value;
    }
    // service_name - computed: true, optional: false, required: true
    get serviceName() {
        return this.getStringAttribute('service_name');
    }
    get value() {
        return this._value;
    }
    set value(value) {
        this._value = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            quota_code: this._quotaCode,
            service_code: this._serviceCode,
            value: this._value,
        };
    }
}
exports.ServicequotasServiceQuota = ServicequotasServiceQuota;
//# sourceMappingURL=data:application/json;base64,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