import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SesEventDestinationConfig extends TerraformMetaArguments {
    readonly configurationSetName: string;
    readonly enabled?: boolean;
    readonly matchingTypes: string[];
    readonly name: string;
    /** cloudwatch_destination block */
    readonly cloudwatchDestination?: SesEventDestinationCloudwatchDestination[];
    /** kinesis_destination block */
    readonly kinesisDestination?: SesEventDestinationKinesisDestination[];
    /** sns_destination block */
    readonly snsDestination?: SesEventDestinationSnsDestination[];
}
export interface SesEventDestinationCloudwatchDestination {
    readonly defaultValue: string;
    readonly dimensionName: string;
    readonly valueSource: string;
}
export interface SesEventDestinationKinesisDestination {
    readonly roleArn: string;
    readonly streamArn: string;
}
export interface SesEventDestinationSnsDestination {
    readonly topicArn: string;
}
export declare class SesEventDestination extends TerraformResource {
    constructor(scope: Construct, id: string, config: SesEventDestinationConfig);
    private _configurationSetName;
    get configurationSetName(): string;
    set configurationSetName(value: string);
    private _enabled?;
    get enabled(): boolean | undefined;
    set enabled(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _matchingTypes;
    get matchingTypes(): string[];
    set matchingTypes(value: string[]);
    private _name;
    get name(): string;
    set name(value: string);
    private _cloudwatchDestination?;
    get cloudwatchDestination(): SesEventDestinationCloudwatchDestination[] | undefined;
    set cloudwatchDestination(value: SesEventDestinationCloudwatchDestination[] | undefined);
    private _kinesisDestination?;
    get kinesisDestination(): SesEventDestinationKinesisDestination[] | undefined;
    set kinesisDestination(value: SesEventDestinationKinesisDestination[] | undefined);
    private _snsDestination?;
    get snsDestination(): SesEventDestinationSnsDestination[] | undefined;
    set snsDestination(value: SesEventDestinationSnsDestination[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
