"use strict";
// https://www.terraform.io/docs/providers/aws/r/ses_event_destination.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.SesEventDestination = void 0;
const cdktf_1 = require("cdktf");
// Resource
class SesEventDestination extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_ses_event_destination',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._configurationSetName = config.configurationSetName;
        this._enabled = config.enabled;
        this._matchingTypes = config.matchingTypes;
        this._name = config.name;
        this._cloudwatchDestination = config.cloudwatchDestination;
        this._kinesisDestination = config.kinesisDestination;
        this._snsDestination = config.snsDestination;
    }
    get configurationSetName() {
        return this._configurationSetName;
    }
    set configurationSetName(value) {
        this._configurationSetName = value;
    }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        this._enabled = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get matchingTypes() {
        return this._matchingTypes;
    }
    set matchingTypes(value) {
        this._matchingTypes = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get cloudwatchDestination() {
        return this._cloudwatchDestination;
    }
    set cloudwatchDestination(value) {
        this._cloudwatchDestination = value;
    }
    get kinesisDestination() {
        return this._kinesisDestination;
    }
    set kinesisDestination(value) {
        this._kinesisDestination = value;
    }
    get snsDestination() {
        return this._snsDestination;
    }
    set snsDestination(value) {
        this._snsDestination = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            configuration_set_name: this._configurationSetName,
            enabled: this._enabled,
            matching_types: this._matchingTypes,
            name: this._name,
            cloudwatch_destination: this._cloudwatchDestination,
            kinesis_destination: this._kinesisDestination,
            sns_destination: this._snsDestination,
        };
    }
}
exports.SesEventDestination = SesEventDestination;
//# sourceMappingURL=data:application/json;base64,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