import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SesReceiptRuleConfig extends TerraformMetaArguments {
    readonly after?: string;
    readonly enabled?: boolean;
    readonly name: string;
    readonly recipients?: string[];
    readonly ruleSetName: string;
    readonly scanEnabled?: boolean;
    readonly tlsPolicy?: string;
    /** add_header_action block */
    readonly addHeaderAction?: SesReceiptRuleAddHeaderAction[];
    /** bounce_action block */
    readonly bounceAction?: SesReceiptRuleBounceAction[];
    /** lambda_action block */
    readonly lambdaAction?: SesReceiptRuleLambdaAction[];
    /** s3_action block */
    readonly s3Action?: SesReceiptRuleS3Action[];
    /** sns_action block */
    readonly snsAction?: SesReceiptRuleSnsAction[];
    /** stop_action block */
    readonly stopAction?: SesReceiptRuleStopAction[];
    /** workmail_action block */
    readonly workmailAction?: SesReceiptRuleWorkmailAction[];
}
export interface SesReceiptRuleAddHeaderAction {
    readonly headerName: string;
    readonly headerValue: string;
    readonly position: number;
}
export interface SesReceiptRuleBounceAction {
    readonly message: string;
    readonly position: number;
    readonly sender: string;
    readonly smtpReplyCode: string;
    readonly statusCode?: string;
    readonly topicArn?: string;
}
export interface SesReceiptRuleLambdaAction {
    readonly functionArn: string;
    readonly invocationType?: string;
    readonly position: number;
    readonly topicArn?: string;
}
export interface SesReceiptRuleS3Action {
    readonly bucketName: string;
    readonly kmsKeyArn?: string;
    readonly objectKeyPrefix?: string;
    readonly position: number;
    readonly topicArn?: string;
}
export interface SesReceiptRuleSnsAction {
    readonly position: number;
    readonly topicArn: string;
}
export interface SesReceiptRuleStopAction {
    readonly position: number;
    readonly scope: string;
    readonly topicArn?: string;
}
export interface SesReceiptRuleWorkmailAction {
    readonly organizationArn: string;
    readonly position: number;
    readonly topicArn?: string;
}
export declare class SesReceiptRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: SesReceiptRuleConfig);
    private _after?;
    get after(): string | undefined;
    set after(value: string | undefined);
    private _enabled?;
    get enabled(): boolean | undefined;
    set enabled(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _recipients?;
    get recipients(): string[] | undefined;
    set recipients(value: string[] | undefined);
    private _ruleSetName;
    get ruleSetName(): string;
    set ruleSetName(value: string);
    private _scanEnabled?;
    get scanEnabled(): boolean | undefined;
    set scanEnabled(value: boolean | undefined);
    private _tlsPolicy?;
    get tlsPolicy(): string | undefined;
    set tlsPolicy(value: string | undefined);
    private _addHeaderAction?;
    get addHeaderAction(): SesReceiptRuleAddHeaderAction[] | undefined;
    set addHeaderAction(value: SesReceiptRuleAddHeaderAction[] | undefined);
    private _bounceAction?;
    get bounceAction(): SesReceiptRuleBounceAction[] | undefined;
    set bounceAction(value: SesReceiptRuleBounceAction[] | undefined);
    private _lambdaAction?;
    get lambdaAction(): SesReceiptRuleLambdaAction[] | undefined;
    set lambdaAction(value: SesReceiptRuleLambdaAction[] | undefined);
    private _s3Action?;
    get s3Action(): SesReceiptRuleS3Action[] | undefined;
    set s3Action(value: SesReceiptRuleS3Action[] | undefined);
    private _snsAction?;
    get snsAction(): SesReceiptRuleSnsAction[] | undefined;
    set snsAction(value: SesReceiptRuleSnsAction[] | undefined);
    private _stopAction?;
    get stopAction(): SesReceiptRuleStopAction[] | undefined;
    set stopAction(value: SesReceiptRuleStopAction[] | undefined);
    private _workmailAction?;
    get workmailAction(): SesReceiptRuleWorkmailAction[] | undefined;
    set workmailAction(value: SesReceiptRuleWorkmailAction[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
