"use strict";
// https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.SesReceiptRule = void 0;
const cdktf_1 = require("cdktf");
// Resource
class SesReceiptRule extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_ses_receipt_rule',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._after = config.after;
        this._enabled = config.enabled;
        this._name = config.name;
        this._recipients = config.recipients;
        this._ruleSetName = config.ruleSetName;
        this._scanEnabled = config.scanEnabled;
        this._tlsPolicy = config.tlsPolicy;
        this._addHeaderAction = config.addHeaderAction;
        this._bounceAction = config.bounceAction;
        this._lambdaAction = config.lambdaAction;
        this._s3Action = config.s3Action;
        this._snsAction = config.snsAction;
        this._stopAction = config.stopAction;
        this._workmailAction = config.workmailAction;
    }
    get after() {
        return this._after;
    }
    set after(value) {
        this._after = value;
    }
    get enabled() {
        var _a;
        return (_a = this._enabled) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get recipients() {
        return this._recipients;
    }
    set recipients(value) {
        this._recipients = value;
    }
    get ruleSetName() {
        return this._ruleSetName;
    }
    set ruleSetName(value) {
        this._ruleSetName = value;
    }
    get scanEnabled() {
        var _a;
        return (_a = this._scanEnabled) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('scan_enabled');
    }
    set scanEnabled(value) {
        this._scanEnabled = value;
    }
    get tlsPolicy() {
        var _a;
        return (_a = this._tlsPolicy) !== null && _a !== void 0 ? _a : this.getStringAttribute('tls_policy');
    }
    set tlsPolicy(value) {
        this._tlsPolicy = value;
    }
    get addHeaderAction() {
        return this._addHeaderAction;
    }
    set addHeaderAction(value) {
        this._addHeaderAction = value;
    }
    get bounceAction() {
        return this._bounceAction;
    }
    set bounceAction(value) {
        this._bounceAction = value;
    }
    get lambdaAction() {
        return this._lambdaAction;
    }
    set lambdaAction(value) {
        this._lambdaAction = value;
    }
    get s3Action() {
        return this._s3Action;
    }
    set s3Action(value) {
        this._s3Action = value;
    }
    get snsAction() {
        return this._snsAction;
    }
    set snsAction(value) {
        this._snsAction = value;
    }
    get stopAction() {
        return this._stopAction;
    }
    set stopAction(value) {
        this._stopAction = value;
    }
    get workmailAction() {
        return this._workmailAction;
    }
    set workmailAction(value) {
        this._workmailAction = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            after: this._after,
            enabled: this._enabled,
            name: this._name,
            recipients: this._recipients,
            rule_set_name: this._ruleSetName,
            scan_enabled: this._scanEnabled,
            tls_policy: this._tlsPolicy,
            add_header_action: this._addHeaderAction,
            bounce_action: this._bounceAction,
            lambda_action: this._lambdaAction,
            s3_action: this._s3Action,
            sns_action: this._snsAction,
            stop_action: this._stopAction,
            workmail_action: this._workmailAction,
        };
    }
}
exports.SesReceiptRule = SesReceiptRule;
//# sourceMappingURL=data:application/json;base64,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