import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SfnStateMachineConfig extends TerraformMetaArguments {
    readonly definition: string;
    readonly name: string;
    readonly roleArn: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class SfnStateMachine extends TerraformResource {
    constructor(scope: Construct, id: string, config: SfnStateMachineConfig);
    get arn(): string;
    get creationDate(): string;
    private _definition;
    get definition(): string;
    set definition(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _roleArn;
    get roleArn(): string;
    set roleArn(value: string);
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
