import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SnsPlatformApplicationConfig extends TerraformMetaArguments {
    readonly eventDeliveryFailureTopicArn?: string;
    readonly eventEndpointCreatedTopicArn?: string;
    readonly eventEndpointDeletedTopicArn?: string;
    readonly eventEndpointUpdatedTopicArn?: string;
    readonly failureFeedbackRoleArn?: string;
    readonly name: string;
    readonly platform: string;
    readonly platformCredential: string;
    readonly platformPrincipal?: string;
    readonly successFeedbackRoleArn?: string;
    readonly successFeedbackSampleRate?: string;
}
export declare class SnsPlatformApplication extends TerraformResource {
    constructor(scope: Construct, id: string, config: SnsPlatformApplicationConfig);
    get arn(): string;
    private _eventDeliveryFailureTopicArn?;
    get eventDeliveryFailureTopicArn(): string | undefined;
    set eventDeliveryFailureTopicArn(value: string | undefined);
    private _eventEndpointCreatedTopicArn?;
    get eventEndpointCreatedTopicArn(): string | undefined;
    set eventEndpointCreatedTopicArn(value: string | undefined);
    private _eventEndpointDeletedTopicArn?;
    get eventEndpointDeletedTopicArn(): string | undefined;
    set eventEndpointDeletedTopicArn(value: string | undefined);
    private _eventEndpointUpdatedTopicArn?;
    get eventEndpointUpdatedTopicArn(): string | undefined;
    set eventEndpointUpdatedTopicArn(value: string | undefined);
    private _failureFeedbackRoleArn?;
    get failureFeedbackRoleArn(): string | undefined;
    set failureFeedbackRoleArn(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _platform;
    get platform(): string;
    set platform(value: string);
    private _platformCredential;
    get platformCredential(): string;
    set platformCredential(value: string);
    private _platformPrincipal?;
    get platformPrincipal(): string | undefined;
    set platformPrincipal(value: string | undefined);
    private _successFeedbackRoleArn?;
    get successFeedbackRoleArn(): string | undefined;
    set successFeedbackRoleArn(value: string | undefined);
    private _successFeedbackSampleRate?;
    get successFeedbackSampleRate(): string | undefined;
    set successFeedbackSampleRate(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
