"use strict";
// https://www.terraform.io/docs/providers/aws/r/sns_platform_application.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsPlatformApplication = void 0;
const cdktf_1 = require("cdktf");
// Resource
class SnsPlatformApplication extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_sns_platform_application',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._eventDeliveryFailureTopicArn = config.eventDeliveryFailureTopicArn;
        this._eventEndpointCreatedTopicArn = config.eventEndpointCreatedTopicArn;
        this._eventEndpointDeletedTopicArn = config.eventEndpointDeletedTopicArn;
        this._eventEndpointUpdatedTopicArn = config.eventEndpointUpdatedTopicArn;
        this._failureFeedbackRoleArn = config.failureFeedbackRoleArn;
        this._name = config.name;
        this._platform = config.platform;
        this._platformCredential = config.platformCredential;
        this._platformPrincipal = config.platformPrincipal;
        this._successFeedbackRoleArn = config.successFeedbackRoleArn;
        this._successFeedbackSampleRate = config.successFeedbackSampleRate;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get eventDeliveryFailureTopicArn() {
        return this._eventDeliveryFailureTopicArn;
    }
    set eventDeliveryFailureTopicArn(value) {
        this._eventDeliveryFailureTopicArn = value;
    }
    get eventEndpointCreatedTopicArn() {
        return this._eventEndpointCreatedTopicArn;
    }
    set eventEndpointCreatedTopicArn(value) {
        this._eventEndpointCreatedTopicArn = value;
    }
    get eventEndpointDeletedTopicArn() {
        return this._eventEndpointDeletedTopicArn;
    }
    set eventEndpointDeletedTopicArn(value) {
        this._eventEndpointDeletedTopicArn = value;
    }
    get eventEndpointUpdatedTopicArn() {
        return this._eventEndpointUpdatedTopicArn;
    }
    set eventEndpointUpdatedTopicArn(value) {
        this._eventEndpointUpdatedTopicArn = value;
    }
    get failureFeedbackRoleArn() {
        return this._failureFeedbackRoleArn;
    }
    set failureFeedbackRoleArn(value) {
        this._failureFeedbackRoleArn = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get platform() {
        return this._platform;
    }
    set platform(value) {
        this._platform = value;
    }
    get platformCredential() {
        return this._platformCredential;
    }
    set platformCredential(value) {
        this._platformCredential = value;
    }
    get platformPrincipal() {
        return this._platformPrincipal;
    }
    set platformPrincipal(value) {
        this._platformPrincipal = value;
    }
    get successFeedbackRoleArn() {
        return this._successFeedbackRoleArn;
    }
    set successFeedbackRoleArn(value) {
        this._successFeedbackRoleArn = value;
    }
    get successFeedbackSampleRate() {
        return this._successFeedbackSampleRate;
    }
    set successFeedbackSampleRate(value) {
        this._successFeedbackSampleRate = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            event_delivery_failure_topic_arn: this._eventDeliveryFailureTopicArn,
            event_endpoint_created_topic_arn: this._eventEndpointCreatedTopicArn,
            event_endpoint_deleted_topic_arn: this._eventEndpointDeletedTopicArn,
            event_endpoint_updated_topic_arn: this._eventEndpointUpdatedTopicArn,
            failure_feedback_role_arn: this._failureFeedbackRoleArn,
            name: this._name,
            platform: this._platform,
            platform_credential: this._platformCredential,
            platform_principal: this._platformPrincipal,
            success_feedback_role_arn: this._successFeedbackRoleArn,
            success_feedback_sample_rate: this._successFeedbackSampleRate,
        };
    }
}
exports.SnsPlatformApplication = SnsPlatformApplication;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLXBsYXRmb3JtLWFwcGxpY2F0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3Nucy1wbGF0Zm9ybS1hcHBsaWNhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsOEVBQThFO0FBQzlFLDJDQUEyQzs7O0FBaUUzQyxpQ0FBMEM7QUFtQjFDLFdBQVc7QUFFWCxNQUFhLHNCQUF1QixTQUFRLHlCQUFpQjtJQUUzRCxjQUFjO0lBQ2QsY0FBYztJQUNkLGNBQWM7SUFFZCxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxNQUFvQztRQUNuRixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLHFCQUFxQixFQUFFLDhCQUE4QjtZQUNyRCwwQkFBMEIsRUFBRTtnQkFDMUIsWUFBWSxFQUFFLEtBQUs7YUFDcEI7WUFDRCxRQUFRLEVBQUUsTUFBTSxDQUFDLFFBQVE7WUFDekIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1lBQzNCLEtBQUssRUFBRSxNQUFNLENBQUMsS0FBSztZQUNuQixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7U0FDNUIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLDZCQUE2QixHQUFHLE1BQU0sQ0FBQyw0QkFBNEIsQ0FBQztRQUN6RSxJQUFJLENBQUMsNkJBQTZCLEdBQUcsTUFBTSxDQUFDLDRCQUE0QixDQUFDO1FBQ3pFLElBQUksQ0FBQyw2QkFBNkIsR0FBRyxNQUFNLENBQUMsNEJBQTRCLENBQUM7UUFDekUsSUFBSSxDQUFDLDZCQUE2QixHQUFHLE1BQU0sQ0FBQyw0QkFBNEIsQ0FBQztRQUN6RSxJQUFJLENBQUMsdUJBQXVCLEdBQUcsTUFBTSxDQUFDLHNCQUFzQixDQUFDO1FBQzdELElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUM7UUFDakMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQztRQUNyRCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsTUFBTSxDQUFDLGlCQUFpQixDQUFDO1FBQ25ELElBQUksQ0FBQyx1QkFBdUIsR0FBRyxNQUFNLENBQUMsc0JBQXNCLENBQUM7UUFDN0QsSUFBSSxDQUFDLDBCQUEwQixHQUFHLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQztJQUNyRSxDQUFDO0lBRUQsYUFBYTtJQUNiLGFBQWE7SUFDYixhQUFhO0lBRWIsd0RBQXdEO0lBQ3hELElBQVcsR0FBRztRQUNaLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFJRCxJQUFXLDRCQUE0QjtRQUNyQyxPQUFPLElBQUksQ0FBQyw2QkFBNkIsQ0FBQztJQUM1QyxDQUFDO0lBQ0QsSUFBVyw0QkFBNEIsQ0FBQyxLQUF5QjtRQUMvRCxJQUFJLENBQUMsNkJBQTZCLEdBQUcsS0FBSyxDQUFDO0lBQzdDLENBQUM7SUFJRCxJQUFXLDRCQUE0QjtRQUNyQyxPQUFPLElBQUksQ0FBQyw2QkFBNkIsQ0FBQztJQUM1QyxDQUFDO0lBQ0QsSUFBVyw0QkFBNEIsQ0FBQyxLQUF5QjtRQUMvRCxJQUFJLENBQUMsNkJBQTZCLEdBQUcsS0FBSyxDQUFDO0lBQzdDLENBQUM7SUFJRCxJQUFXLDRCQUE0QjtRQUNyQyxPQUFPLElBQUksQ0FBQyw2QkFBNkIsQ0FBQztJQUM1QyxDQUFDO0lBQ0QsSUFBVyw0QkFBNEIsQ0FBQyxLQUF5QjtRQUMvRCxJQUFJLENBQUMsNkJBQTZCLEdBQUcsS0FBSyxDQUFDO0lBQzdDLENBQUM7SUFJRCxJQUFXLDRCQUE0QjtRQUNyQyxPQUFPLElBQUksQ0FBQyw2QkFBNkIsQ0FBQztJQUM1QyxDQUFDO0lBQ0QsSUFBVyw0QkFBNEIsQ0FBQyxLQUF5QjtRQUMvRCxJQUFJLENBQUMsNkJBQTZCLEdBQUcsS0FBSyxDQUFDO0lBQzdDLENBQUM7SUFJRCxJQUFXLHNCQUFzQjtRQUMvQixPQUFPLElBQUksQ0FBQyx1QkFBdUIsQ0FBQztJQUN0QyxDQUFDO0lBQ0QsSUFBVyxzQkFBc0IsQ0FBQyxLQUF5QjtRQUN6RCxJQUFJLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDO0lBQ3ZDLENBQUM7SUFJRCxJQUFXLEVBQUU7O1FBQ1gsYUFBTyxJQUFJLENBQUMsR0FBRyxtQ0FBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQXlCO1FBQ3JDLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDO0lBQ25CLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUNELElBQVcsUUFBUSxDQUFDLEtBQWE7UUFDL0IsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUM7SUFDekIsQ0FBQztJQUlELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDO0lBQ2xDLENBQUM7SUFDRCxJQUFXLGtCQUFrQixDQUFDLEtBQWE7UUFDekMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQztJQUNuQyxDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUNELElBQVcsaUJBQWlCLENBQUMsS0FBeUI7UUFDcEQsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztJQUNsQyxDQUFDO0lBSUQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsdUJBQXVCLENBQUM7SUFDdEMsQ0FBQztJQUNELElBQVcsc0JBQXNCLENBQUMsS0FBeUI7UUFDekQsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQztJQUN2QyxDQUFDO0lBSUQsSUFBVyx5QkFBeUI7UUFDbEMsT0FBTyxJQUFJLENBQUMsMEJBQTBCLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcseUJBQXlCLENBQUMsS0FBeUI7UUFDNUQsSUFBSSxDQUFDLDBCQUEwQixHQUFHLEtBQUssQ0FBQztJQUMxQyxDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZO0lBRUwsb0JBQW9CO1FBQ3pCLE9BQU87WUFDTCxnQ0FBZ0MsRUFBRSxJQUFJLENBQUMsNkJBQTZCO1lBQ3BFLGdDQUFnQyxFQUFFLElBQUksQ0FBQyw2QkFBNkI7WUFDcEUsZ0NBQWdDLEVBQUUsSUFBSSxDQUFDLDZCQUE2QjtZQUNwRSxnQ0FBZ0MsRUFBRSxJQUFJLENBQUMsNkJBQTZCO1lBQ3BFLHlCQUF5QixFQUFFLElBQUksQ0FBQyx1QkFBdUI7WUFDdkQsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLO1lBQ2hCLFFBQVEsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN4QixtQkFBbUIsRUFBRSxJQUFJLENBQUMsbUJBQW1CO1lBQzdDLGtCQUFrQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDM0MseUJBQXlCLEVBQUUsSUFBSSxDQUFDLHVCQUF1QjtZQUN2RCw0QkFBNEIsRUFBRSxJQUFJLENBQUMsMEJBQTBCO1NBQzlELENBQUM7SUFDSixDQUFDO0NBQ0Y7QUF0S0Qsd0RBc0tDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F3cy9yL3Nuc19wbGF0Zm9ybV9hcHBsaWNhdGlvbi5odG1sXG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbi8qXG57XG4gIFwidmVyc2lvblwiOiAwLFxuICBcImJsb2NrXCI6IHtcbiAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgXCJhcm5cIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJldmVudF9kZWxpdmVyeV9mYWlsdXJlX3RvcGljX2FyblwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImV2ZW50X2VuZHBvaW50X2NyZWF0ZWRfdG9waWNfYXJuXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiZXZlbnRfZW5kcG9pbnRfZGVsZXRlZF90b3BpY19hcm5cIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJldmVudF9lbmRwb2ludF91cGRhdGVkX3RvcGljX2FyblwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImZhaWx1cmVfZmVlZGJhY2tfcm9sZV9hcm5cIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJpZFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwibmFtZVwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInBsYXRmb3JtXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwicGxhdGZvcm1fY3JlZGVudGlhbFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInBsYXRmb3JtX3ByaW5jaXBhbFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInN1Y2Nlc3NfZmVlZGJhY2tfcm9sZV9hcm5cIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJzdWNjZXNzX2ZlZWRiYWNrX3NhbXBsZV9yYXRlXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfVxuICAgIH1cbiAgfVxufVxuKi9cbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgVGVycmFmb3JtUmVzb3VyY2UgfSBmcm9tICdjZGt0Zic7XG5pbXBvcnQgeyBUZXJyYWZvcm1NZXRhQXJndW1lbnRzIH0gZnJvbSAnY2RrdGYnO1xuXG4vLyBDb25maWd1cmF0aW9uXG5cbmV4cG9ydCBpbnRlcmZhY2UgU25zUGxhdGZvcm1BcHBsaWNhdGlvbkNvbmZpZyBleHRlbmRzIFRlcnJhZm9ybU1ldGFBcmd1bWVudHMge1xuICByZWFkb25seSBldmVudERlbGl2ZXJ5RmFpbHVyZVRvcGljQXJuPzogc3RyaW5nO1xuICByZWFkb25seSBldmVudEVuZHBvaW50Q3JlYXRlZFRvcGljQXJuPzogc3RyaW5nO1xuICByZWFkb25seSBldmVudEVuZHBvaW50RGVsZXRlZFRvcGljQXJuPzogc3RyaW5nO1xuICByZWFkb25seSBldmVudEVuZHBvaW50VXBkYXRlZFRvcGljQXJuPzogc3RyaW5nO1xuICByZWFkb25seSBmYWlsdXJlRmVlZGJhY2tSb2xlQXJuPzogc3RyaW5nO1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHBsYXRmb3JtOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHBsYXRmb3JtQ3JlZGVudGlhbDogc3RyaW5nO1xuICByZWFkb25seSBwbGF0Zm9ybVByaW5jaXBhbD86IHN0cmluZztcbiAgcmVhZG9ubHkgc3VjY2Vzc0ZlZWRiYWNrUm9sZUFybj86IHN0cmluZztcbiAgcmVhZG9ubHkgc3VjY2Vzc0ZlZWRiYWNrU2FtcGxlUmF0ZT86IHN0cmluZztcbn1cblxuLy8gUmVzb3VyY2VcblxuZXhwb3J0IGNsYXNzIFNuc1BsYXRmb3JtQXBwbGljYXRpb24gZXh0ZW5kcyBUZXJyYWZvcm1SZXNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBTbnNQbGF0Zm9ybUFwcGxpY2F0aW9uQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdhd3Nfc25zX3BsYXRmb3JtX2FwcGxpY2F0aW9uJyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2F3cydcbiAgICAgIH0sXG4gICAgICBwcm92aWRlcjogY29uZmlnLnByb3ZpZGVyLFxuICAgICAgZGVwZW5kc09uOiBjb25maWcuZGVwZW5kc09uLFxuICAgICAgY291bnQ6IGNvbmZpZy5jb3VudCxcbiAgICAgIGxpZmVjeWNsZTogY29uZmlnLmxpZmVjeWNsZVxuICAgIH0pO1xuICAgIHRoaXMuX2V2ZW50RGVsaXZlcnlGYWlsdXJlVG9waWNBcm4gPSBjb25maWcuZXZlbnREZWxpdmVyeUZhaWx1cmVUb3BpY0FybjtcbiAgICB0aGlzLl9ldmVudEVuZHBvaW50Q3JlYXRlZFRvcGljQXJuID0gY29uZmlnLmV2ZW50RW5kcG9pbnRDcmVhdGVkVG9waWNBcm47XG4gICAgdGhpcy5fZXZlbnRFbmRwb2ludERlbGV0ZWRUb3BpY0FybiA9IGNvbmZpZy5ldmVudEVuZHBvaW50RGVsZXRlZFRvcGljQXJuO1xuICAgIHRoaXMuX2V2ZW50RW5kcG9pbnRVcGRhdGVkVG9waWNBcm4gPSBjb25maWcuZXZlbnRFbmRwb2ludFVwZGF0ZWRUb3BpY0FybjtcbiAgICB0aGlzLl9mYWlsdXJlRmVlZGJhY2tSb2xlQXJuID0gY29uZmlnLmZhaWx1cmVGZWVkYmFja1JvbGVBcm47XG4gICAgdGhpcy5fbmFtZSA9IGNvbmZpZy5uYW1lO1xuICAgIHRoaXMuX3BsYXRmb3JtID0gY29uZmlnLnBsYXRmb3JtO1xuICAgIHRoaXMuX3BsYXRmb3JtQ3JlZGVudGlhbCA9IGNvbmZpZy5wbGF0Zm9ybUNyZWRlbnRpYWw7XG4gICAgdGhpcy5fcGxhdGZvcm1QcmluY2lwYWwgPSBjb25maWcucGxhdGZvcm1QcmluY2lwYWw7XG4gICAgdGhpcy5fc3VjY2Vzc0ZlZWRiYWNrUm9sZUFybiA9IGNvbmZpZy5zdWNjZXNzRmVlZGJhY2tSb2xlQXJuO1xuICAgIHRoaXMuX3N1Y2Nlc3NGZWVkYmFja1NhbXBsZVJhdGUgPSBjb25maWcuc3VjY2Vzc0ZlZWRiYWNrU2FtcGxlUmF0ZTtcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gYXJuIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHVibGljIGdldCBhcm4oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdhcm4nKTtcbiAgfVxuXG4gIC8vIGV2ZW50X2RlbGl2ZXJ5X2ZhaWx1cmVfdG9waWNfYXJuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2V2ZW50RGVsaXZlcnlGYWlsdXJlVG9waWNBcm4/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgZXZlbnREZWxpdmVyeUZhaWx1cmVUb3BpY0FybigpIHtcbiAgICByZXR1cm4gdGhpcy5fZXZlbnREZWxpdmVyeUZhaWx1cmVUb3BpY0FybjtcbiAgfVxuICBwdWJsaWMgc2V0IGV2ZW50RGVsaXZlcnlGYWlsdXJlVG9waWNBcm4odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2V2ZW50RGVsaXZlcnlGYWlsdXJlVG9waWNBcm4gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGV2ZW50X2VuZHBvaW50X2NyZWF0ZWRfdG9waWNfYXJuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2V2ZW50RW5kcG9pbnRDcmVhdGVkVG9waWNBcm4/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgZXZlbnRFbmRwb2ludENyZWF0ZWRUb3BpY0FybigpIHtcbiAgICByZXR1cm4gdGhpcy5fZXZlbnRFbmRwb2ludENyZWF0ZWRUb3BpY0FybjtcbiAgfVxuICBwdWJsaWMgc2V0IGV2ZW50RW5kcG9pbnRDcmVhdGVkVG9waWNBcm4odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2V2ZW50RW5kcG9pbnRDcmVhdGVkVG9waWNBcm4gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGV2ZW50X2VuZHBvaW50X2RlbGV0ZWRfdG9waWNfYXJuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2V2ZW50RW5kcG9pbnREZWxldGVkVG9waWNBcm4/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgZXZlbnRFbmRwb2ludERlbGV0ZWRUb3BpY0FybigpIHtcbiAgICByZXR1cm4gdGhpcy5fZXZlbnRFbmRwb2ludERlbGV0ZWRUb3BpY0FybjtcbiAgfVxuICBwdWJsaWMgc2V0IGV2ZW50RW5kcG9pbnREZWxldGVkVG9waWNBcm4odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2V2ZW50RW5kcG9pbnREZWxldGVkVG9waWNBcm4gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGV2ZW50X2VuZHBvaW50X3VwZGF0ZWRfdG9waWNfYXJuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2V2ZW50RW5kcG9pbnRVcGRhdGVkVG9waWNBcm4/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgZXZlbnRFbmRwb2ludFVwZGF0ZWRUb3BpY0FybigpIHtcbiAgICByZXR1cm4gdGhpcy5fZXZlbnRFbmRwb2ludFVwZGF0ZWRUb3BpY0FybjtcbiAgfVxuICBwdWJsaWMgc2V0IGV2ZW50RW5kcG9pbnRVcGRhdGVkVG9waWNBcm4odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2V2ZW50RW5kcG9pbnRVcGRhdGVkVG9waWNBcm4gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGZhaWx1cmVfZmVlZGJhY2tfcm9sZV9hcm4gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZmFpbHVyZUZlZWRiYWNrUm9sZUFybj86IHN0cmluZztcbiAgcHVibGljIGdldCBmYWlsdXJlRmVlZGJhY2tSb2xlQXJuKCkge1xuICAgIHJldHVybiB0aGlzLl9mYWlsdXJlRmVlZGJhY2tSb2xlQXJuO1xuICB9XG4gIHB1YmxpYyBzZXQgZmFpbHVyZUZlZWRiYWNrUm9sZUFybih2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fZmFpbHVyZUZlZWRiYWNrUm9sZUFybiA9IHZhbHVlO1xuICB9XG5cbiAgLy8gaWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pZD86IHN0cmluZztcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5faWQgPz8gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBpZCh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5faWQgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIG5hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfbmFtZTogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IG5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuX25hbWU7XG4gIH1cbiAgcHVibGljIHNldCBuYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9uYW1lID0gdmFsdWU7XG4gIH1cblxuICAvLyBwbGF0Zm9ybSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9wbGF0Zm9ybTogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IHBsYXRmb3JtKCkge1xuICAgIHJldHVybiB0aGlzLl9wbGF0Zm9ybTtcbiAgfVxuICBwdWJsaWMgc2V0IHBsYXRmb3JtKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9wbGF0Zm9ybSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gcGxhdGZvcm1fY3JlZGVudGlhbCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9wbGF0Zm9ybUNyZWRlbnRpYWw6IHN0cmluZztcbiAgcHVibGljIGdldCBwbGF0Zm9ybUNyZWRlbnRpYWwoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BsYXRmb3JtQ3JlZGVudGlhbDtcbiAgfVxuICBwdWJsaWMgc2V0IHBsYXRmb3JtQ3JlZGVudGlhbCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcGxhdGZvcm1DcmVkZW50aWFsID0gdmFsdWU7XG4gIH1cblxuICAvLyBwbGF0Zm9ybV9wcmluY2lwYWwgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcGxhdGZvcm1QcmluY2lwYWw/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgcGxhdGZvcm1QcmluY2lwYWwoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BsYXRmb3JtUHJpbmNpcGFsO1xuICB9XG4gIHB1YmxpYyBzZXQgcGxhdGZvcm1QcmluY2lwYWwodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3BsYXRmb3JtUHJpbmNpcGFsID0gdmFsdWU7XG4gIH1cblxuICAvLyBzdWNjZXNzX2ZlZWRiYWNrX3JvbGVfYXJuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3N1Y2Nlc3NGZWVkYmFja1JvbGVBcm4/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgc3VjY2Vzc0ZlZWRiYWNrUm9sZUFybigpIHtcbiAgICByZXR1cm4gdGhpcy5fc3VjY2Vzc0ZlZWRiYWNrUm9sZUFybjtcbiAgfVxuICBwdWJsaWMgc2V0IHN1Y2Nlc3NGZWVkYmFja1JvbGVBcm4odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3N1Y2Nlc3NGZWVkYmFja1JvbGVBcm4gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHN1Y2Nlc3NfZmVlZGJhY2tfc2FtcGxlX3JhdGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc3VjY2Vzc0ZlZWRiYWNrU2FtcGxlUmF0ZT86IHN0cmluZztcbiAgcHVibGljIGdldCBzdWNjZXNzRmVlZGJhY2tTYW1wbGVSYXRlKCkge1xuICAgIHJldHVybiB0aGlzLl9zdWNjZXNzRmVlZGJhY2tTYW1wbGVSYXRlO1xuICB9XG4gIHB1YmxpYyBzZXQgc3VjY2Vzc0ZlZWRiYWNrU2FtcGxlUmF0ZSh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fc3VjY2Vzc0ZlZWRiYWNrU2FtcGxlUmF0ZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gPT09PT09PT09XG4gIC8vIFNZTlRIRVNJU1xuICAvLyA9PT09PT09PT1cblxuICBwdWJsaWMgc3ludGhlc2l6ZUF0dHJpYnV0ZXMoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIHJldHVybiB7XG4gICAgICBldmVudF9kZWxpdmVyeV9mYWlsdXJlX3RvcGljX2FybjogdGhpcy5fZXZlbnREZWxpdmVyeUZhaWx1cmVUb3BpY0FybixcbiAgICAgIGV2ZW50X2VuZHBvaW50X2NyZWF0ZWRfdG9waWNfYXJuOiB0aGlzLl9ldmVudEVuZHBvaW50Q3JlYXRlZFRvcGljQXJuLFxuICAgICAgZXZlbnRfZW5kcG9pbnRfZGVsZXRlZF90b3BpY19hcm46IHRoaXMuX2V2ZW50RW5kcG9pbnREZWxldGVkVG9waWNBcm4sXG4gICAgICBldmVudF9lbmRwb2ludF91cGRhdGVkX3RvcGljX2FybjogdGhpcy5fZXZlbnRFbmRwb2ludFVwZGF0ZWRUb3BpY0FybixcbiAgICAgIGZhaWx1cmVfZmVlZGJhY2tfcm9sZV9hcm46IHRoaXMuX2ZhaWx1cmVGZWVkYmFja1JvbGVBcm4sXG4gICAgICBuYW1lOiB0aGlzLl9uYW1lLFxuICAgICAgcGxhdGZvcm06IHRoaXMuX3BsYXRmb3JtLFxuICAgICAgcGxhdGZvcm1fY3JlZGVudGlhbDogdGhpcy5fcGxhdGZvcm1DcmVkZW50aWFsLFxuICAgICAgcGxhdGZvcm1fcHJpbmNpcGFsOiB0aGlzLl9wbGF0Zm9ybVByaW5jaXBhbCxcbiAgICAgIHN1Y2Nlc3NfZmVlZGJhY2tfcm9sZV9hcm46IHRoaXMuX3N1Y2Nlc3NGZWVkYmFja1JvbGVBcm4sXG4gICAgICBzdWNjZXNzX2ZlZWRiYWNrX3NhbXBsZV9yYXRlOiB0aGlzLl9zdWNjZXNzRmVlZGJhY2tTYW1wbGVSYXRlLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==