"use strict";
// https://www.terraform.io/docs/providers/aws/r/sns_sms_preferences.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsSmsPreferences = void 0;
const cdktf_1 = require("cdktf");
// Resource
class SnsSmsPreferences extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws_sns_sms_preferences',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._defaultSenderId = config.defaultSenderId;
        this._defaultSmsType = config.defaultSmsType;
        this._deliveryStatusIamRoleArn = config.deliveryStatusIamRoleArn;
        this._deliveryStatusSuccessSamplingRate = config.deliveryStatusSuccessSamplingRate;
        this._monthlySpendLimit = config.monthlySpendLimit;
        this._usageReportS3Bucket = config.usageReportS3Bucket;
    }
    get defaultSenderId() {
        return this._defaultSenderId;
    }
    set defaultSenderId(value) {
        this._defaultSenderId = value;
    }
    get defaultSmsType() {
        return this._defaultSmsType;
    }
    set defaultSmsType(value) {
        this._defaultSmsType = value;
    }
    get deliveryStatusIamRoleArn() {
        return this._deliveryStatusIamRoleArn;
    }
    set deliveryStatusIamRoleArn(value) {
        this._deliveryStatusIamRoleArn = value;
    }
    get deliveryStatusSuccessSamplingRate() {
        return this._deliveryStatusSuccessSamplingRate;
    }
    set deliveryStatusSuccessSamplingRate(value) {
        this._deliveryStatusSuccessSamplingRate = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get monthlySpendLimit() {
        return this._monthlySpendLimit;
    }
    set monthlySpendLimit(value) {
        this._monthlySpendLimit = value;
    }
    get usageReportS3Bucket() {
        return this._usageReportS3Bucket;
    }
    set usageReportS3Bucket(value) {
        this._usageReportS3Bucket = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            default_sender_id: this._defaultSenderId,
            default_sms_type: this._defaultSmsType,
            delivery_status_iam_role_arn: this._deliveryStatusIamRoleArn,
            delivery_status_success_sampling_rate: this._deliveryStatusSuccessSamplingRate,
            monthly_spend_limit: this._monthlySpendLimit,
            usage_report_s3_bucket: this._usageReportS3Bucket,
        };
    }
}
exports.SnsSmsPreferences = SnsSmsPreferences;
//# sourceMappingURL=data:application/json;base64,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