import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SnsTopicSubscriptionConfig extends TerraformMetaArguments {
    readonly confirmationTimeoutInMinutes?: number;
    readonly deliveryPolicy?: string;
    readonly endpoint: string;
    readonly endpointAutoConfirms?: boolean;
    readonly filterPolicy?: string;
    readonly protocol: string;
    readonly rawMessageDelivery?: boolean;
    readonly topicArn: string;
}
export declare class SnsTopicSubscription extends TerraformResource {
    constructor(scope: Construct, id: string, config: SnsTopicSubscriptionConfig);
    get arn(): string;
    private _confirmationTimeoutInMinutes?;
    get confirmationTimeoutInMinutes(): number | undefined;
    set confirmationTimeoutInMinutes(value: number | undefined);
    private _deliveryPolicy?;
    get deliveryPolicy(): string | undefined;
    set deliveryPolicy(value: string | undefined);
    private _endpoint;
    get endpoint(): string;
    set endpoint(value: string);
    private _endpointAutoConfirms?;
    get endpointAutoConfirms(): boolean | undefined;
    set endpointAutoConfirms(value: boolean | undefined);
    private _filterPolicy?;
    get filterPolicy(): string | undefined;
    set filterPolicy(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _protocol;
    get protocol(): string;
    set protocol(value: string);
    private _rawMessageDelivery?;
    get rawMessageDelivery(): boolean | undefined;
    set rawMessageDelivery(value: boolean | undefined);
    private _topicArn;
    get topicArn(): string;
    set topicArn(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
