import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SnsTopicConfig extends TerraformMetaArguments {
    readonly applicationFailureFeedbackRoleArn?: string;
    readonly applicationSuccessFeedbackRoleArn?: string;
    readonly applicationSuccessFeedbackSampleRate?: number;
    readonly deliveryPolicy?: string;
    readonly displayName?: string;
    readonly httpFailureFeedbackRoleArn?: string;
    readonly httpSuccessFeedbackRoleArn?: string;
    readonly httpSuccessFeedbackSampleRate?: number;
    readonly kmsMasterKeyId?: string;
    readonly lambdaFailureFeedbackRoleArn?: string;
    readonly lambdaSuccessFeedbackRoleArn?: string;
    readonly lambdaSuccessFeedbackSampleRate?: number;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly policy?: string;
    readonly sqsFailureFeedbackRoleArn?: string;
    readonly sqsSuccessFeedbackRoleArn?: string;
    readonly sqsSuccessFeedbackSampleRate?: number;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class SnsTopic extends TerraformResource {
    constructor(scope: Construct, id: string, config?: SnsTopicConfig);
    private _applicationFailureFeedbackRoleArn?;
    get applicationFailureFeedbackRoleArn(): string | undefined;
    set applicationFailureFeedbackRoleArn(value: string | undefined);
    private _applicationSuccessFeedbackRoleArn?;
    get applicationSuccessFeedbackRoleArn(): string | undefined;
    set applicationSuccessFeedbackRoleArn(value: string | undefined);
    private _applicationSuccessFeedbackSampleRate?;
    get applicationSuccessFeedbackSampleRate(): number | undefined;
    set applicationSuccessFeedbackSampleRate(value: number | undefined);
    get arn(): string;
    private _deliveryPolicy?;
    get deliveryPolicy(): string | undefined;
    set deliveryPolicy(value: string | undefined);
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    private _httpFailureFeedbackRoleArn?;
    get httpFailureFeedbackRoleArn(): string | undefined;
    set httpFailureFeedbackRoleArn(value: string | undefined);
    private _httpSuccessFeedbackRoleArn?;
    get httpSuccessFeedbackRoleArn(): string | undefined;
    set httpSuccessFeedbackRoleArn(value: string | undefined);
    private _httpSuccessFeedbackSampleRate?;
    get httpSuccessFeedbackSampleRate(): number | undefined;
    set httpSuccessFeedbackSampleRate(value: number | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsMasterKeyId?;
    get kmsMasterKeyId(): string | undefined;
    set kmsMasterKeyId(value: string | undefined);
    private _lambdaFailureFeedbackRoleArn?;
    get lambdaFailureFeedbackRoleArn(): string | undefined;
    set lambdaFailureFeedbackRoleArn(value: string | undefined);
    private _lambdaSuccessFeedbackRoleArn?;
    get lambdaSuccessFeedbackRoleArn(): string | undefined;
    set lambdaSuccessFeedbackRoleArn(value: string | undefined);
    private _lambdaSuccessFeedbackSampleRate?;
    get lambdaSuccessFeedbackSampleRate(): number | undefined;
    set lambdaSuccessFeedbackSampleRate(value: number | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _policy?;
    get policy(): string | undefined;
    set policy(value: string | undefined);
    private _sqsFailureFeedbackRoleArn?;
    get sqsFailureFeedbackRoleArn(): string | undefined;
    set sqsFailureFeedbackRoleArn(value: string | undefined);
    private _sqsSuccessFeedbackRoleArn?;
    get sqsSuccessFeedbackRoleArn(): string | undefined;
    set sqsSuccessFeedbackRoleArn(value: string | undefined);
    private _sqsSuccessFeedbackSampleRate?;
    get sqsSuccessFeedbackSampleRate(): number | undefined;
    set sqsSuccessFeedbackSampleRate(value: number | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
