"use strict";
// https://www.terraform.io/docs/providers/aws/r/sns_topic.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsTopic = void 0;
const cdktf_1 = require("cdktf");
// Resource
class SnsTopic extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws_sns_topic',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._applicationFailureFeedbackRoleArn = config.applicationFailureFeedbackRoleArn;
        this._applicationSuccessFeedbackRoleArn = config.applicationSuccessFeedbackRoleArn;
        this._applicationSuccessFeedbackSampleRate = config.applicationSuccessFeedbackSampleRate;
        this._deliveryPolicy = config.deliveryPolicy;
        this._displayName = config.displayName;
        this._httpFailureFeedbackRoleArn = config.httpFailureFeedbackRoleArn;
        this._httpSuccessFeedbackRoleArn = config.httpSuccessFeedbackRoleArn;
        this._httpSuccessFeedbackSampleRate = config.httpSuccessFeedbackSampleRate;
        this._kmsMasterKeyId = config.kmsMasterKeyId;
        this._lambdaFailureFeedbackRoleArn = config.lambdaFailureFeedbackRoleArn;
        this._lambdaSuccessFeedbackRoleArn = config.lambdaSuccessFeedbackRoleArn;
        this._lambdaSuccessFeedbackSampleRate = config.lambdaSuccessFeedbackSampleRate;
        this._name = config.name;
        this._namePrefix = config.namePrefix;
        this._policy = config.policy;
        this._sqsFailureFeedbackRoleArn = config.sqsFailureFeedbackRoleArn;
        this._sqsSuccessFeedbackRoleArn = config.sqsSuccessFeedbackRoleArn;
        this._sqsSuccessFeedbackSampleRate = config.sqsSuccessFeedbackSampleRate;
        this._tags = config.tags;
    }
    get applicationFailureFeedbackRoleArn() {
        return this._applicationFailureFeedbackRoleArn;
    }
    set applicationFailureFeedbackRoleArn(value) {
        this._applicationFailureFeedbackRoleArn = value;
    }
    get applicationSuccessFeedbackRoleArn() {
        return this._applicationSuccessFeedbackRoleArn;
    }
    set applicationSuccessFeedbackRoleArn(value) {
        this._applicationSuccessFeedbackRoleArn = value;
    }
    get applicationSuccessFeedbackSampleRate() {
        return this._applicationSuccessFeedbackSampleRate;
    }
    set applicationSuccessFeedbackSampleRate(value) {
        this._applicationSuccessFeedbackSampleRate = value;
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get deliveryPolicy() {
        return this._deliveryPolicy;
    }
    set deliveryPolicy(value) {
        this._deliveryPolicy = value;
    }
    get displayName() {
        return this._displayName;
    }
    set displayName(value) {
        this._displayName = value;
    }
    get httpFailureFeedbackRoleArn() {
        return this._httpFailureFeedbackRoleArn;
    }
    set httpFailureFeedbackRoleArn(value) {
        this._httpFailureFeedbackRoleArn = value;
    }
    get httpSuccessFeedbackRoleArn() {
        return this._httpSuccessFeedbackRoleArn;
    }
    set httpSuccessFeedbackRoleArn(value) {
        this._httpSuccessFeedbackRoleArn = value;
    }
    get httpSuccessFeedbackSampleRate() {
        return this._httpSuccessFeedbackSampleRate;
    }
    set httpSuccessFeedbackSampleRate(value) {
        this._httpSuccessFeedbackSampleRate = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get kmsMasterKeyId() {
        return this._kmsMasterKeyId;
    }
    set kmsMasterKeyId(value) {
        this._kmsMasterKeyId = value;
    }
    get lambdaFailureFeedbackRoleArn() {
        return this._lambdaFailureFeedbackRoleArn;
    }
    set lambdaFailureFeedbackRoleArn(value) {
        this._lambdaFailureFeedbackRoleArn = value;
    }
    get lambdaSuccessFeedbackRoleArn() {
        return this._lambdaSuccessFeedbackRoleArn;
    }
    set lambdaSuccessFeedbackRoleArn(value) {
        this._lambdaSuccessFeedbackRoleArn = value;
    }
    get lambdaSuccessFeedbackSampleRate() {
        return this._lambdaSuccessFeedbackSampleRate;
    }
    set lambdaSuccessFeedbackSampleRate(value) {
        this._lambdaSuccessFeedbackSampleRate = value;
    }
    get name() {
        var _a;
        return (_a = this._name) !== null && _a !== void 0 ? _a : this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    get namePrefix() {
        return this._namePrefix;
    }
    set namePrefix(value) {
        this._namePrefix = value;
    }
    get policy() {
        var _a;
        return (_a = this._policy) !== null && _a !== void 0 ? _a : this.getStringAttribute('policy');
    }
    set policy(value) {
        this._policy = value;
    }
    get sqsFailureFeedbackRoleArn() {
        return this._sqsFailureFeedbackRoleArn;
    }
    set sqsFailureFeedbackRoleArn(value) {
        this._sqsFailureFeedbackRoleArn = value;
    }
    get sqsSuccessFeedbackRoleArn() {
        return this._sqsSuccessFeedbackRoleArn;
    }
    set sqsSuccessFeedbackRoleArn(value) {
        this._sqsSuccessFeedbackRoleArn = value;
    }
    get sqsSuccessFeedbackSampleRate() {
        return this._sqsSuccessFeedbackSampleRate;
    }
    set sqsSuccessFeedbackSampleRate(value) {
        this._sqsSuccessFeedbackSampleRate = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            application_failure_feedback_role_arn: this._applicationFailureFeedbackRoleArn,
            application_success_feedback_role_arn: this._applicationSuccessFeedbackRoleArn,
            application_success_feedback_sample_rate: this._applicationSuccessFeedbackSampleRate,
            delivery_policy: this._deliveryPolicy,
            display_name: this._displayName,
            http_failure_feedback_role_arn: this._httpFailureFeedbackRoleArn,
            http_success_feedback_role_arn: this._httpSuccessFeedbackRoleArn,
            http_success_feedback_sample_rate: this._httpSuccessFeedbackSampleRate,
            kms_master_key_id: this._kmsMasterKeyId,
            lambda_failure_feedback_role_arn: this._lambdaFailureFeedbackRoleArn,
            lambda_success_feedback_role_arn: this._lambdaSuccessFeedbackRoleArn,
            lambda_success_feedback_sample_rate: this._lambdaSuccessFeedbackSampleRate,
            name: this._name,
            name_prefix: this._namePrefix,
            policy: this._policy,
            sqs_failure_feedback_role_arn: this._sqsFailureFeedbackRoleArn,
            sqs_success_feedback_role_arn: this._sqsSuccessFeedbackRoleArn,
            sqs_success_feedback_sample_rate: this._sqsSuccessFeedbackSampleRate,
            tags: this._tags,
        };
    }
}
exports.SnsTopic = SnsTopic;
//# sourceMappingURL=data:application/json;base64,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