import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SpotFleetRequestConfig extends TerraformMetaArguments {
    readonly allocationStrategy?: string;
    readonly excessCapacityTerminationPolicy?: string;
    readonly fleetType?: string;
    readonly iamFleetRole: string;
    readonly instanceInterruptionBehaviour?: string;
    readonly instancePoolsToUseCount?: number;
    readonly loadBalancers?: string[];
    readonly replaceUnhealthyInstances?: boolean;
    readonly spotPrice?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly targetCapacity: number;
    readonly targetGroupArns?: string[];
    readonly terminateInstancesWithExpiration?: boolean;
    readonly validFrom?: string;
    readonly validUntil?: string;
    readonly waitForFulfillment?: boolean;
    /** launch_specification block */
    readonly launchSpecification?: SpotFleetRequestLaunchSpecification[];
    /** launch_template_config block */
    readonly launchTemplateConfig?: SpotFleetRequestLaunchTemplateConfig[];
    /** timeouts block */
    readonly timeouts?: SpotFleetRequestTimeouts;
}
export interface SpotFleetRequestLaunchSpecificationEbsBlockDevice {
    readonly deleteOnTermination?: boolean;
    readonly deviceName: string;
    readonly encrypted?: boolean;
    readonly iops?: number;
    readonly kmsKeyId?: string;
    readonly snapshotId?: string;
    readonly volumeSize?: number;
    readonly volumeType?: string;
}
export interface SpotFleetRequestLaunchSpecificationEphemeralBlockDevice {
    readonly deviceName: string;
    readonly virtualName: string;
}
export interface SpotFleetRequestLaunchSpecificationRootBlockDevice {
    readonly deleteOnTermination?: boolean;
    readonly encrypted?: boolean;
    readonly iops?: number;
    readonly kmsKeyId?: string;
    readonly volumeSize?: number;
    readonly volumeType?: string;
}
export interface SpotFleetRequestLaunchSpecification {
    readonly ami: string;
    readonly associatePublicIpAddress?: boolean;
    readonly availabilityZone?: string;
    readonly ebsOptimized?: boolean;
    readonly iamInstanceProfile?: string;
    readonly iamInstanceProfileArn?: string;
    readonly instanceType: string;
    readonly keyName?: string;
    readonly monitoring?: boolean;
    readonly placementGroup?: string;
    readonly placementTenancy?: string;
    readonly spotPrice?: string;
    readonly subnetId?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly userData?: string;
    readonly vpcSecurityGroupIds?: string[];
    readonly weightedCapacity?: string;
    /** ebs_block_device block */
    readonly ebsBlockDevice?: SpotFleetRequestLaunchSpecificationEbsBlockDevice[];
    /** ephemeral_block_device block */
    readonly ephemeralBlockDevice?: SpotFleetRequestLaunchSpecificationEphemeralBlockDevice[];
    /** root_block_device block */
    readonly rootBlockDevice?: SpotFleetRequestLaunchSpecificationRootBlockDevice[];
}
export interface SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecification {
    readonly id?: string;
    readonly name?: string;
    readonly version?: string;
}
export interface SpotFleetRequestLaunchTemplateConfigOverrides {
    readonly availabilityZone?: string;
    readonly instanceType?: string;
    readonly priority?: number;
    readonly spotPrice?: string;
    readonly subnetId?: string;
    readonly weightedCapacity?: number;
}
export interface SpotFleetRequestLaunchTemplateConfig {
    /** launch_template_specification block */
    readonly launchTemplateSpecification: SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecification[];
    /** overrides block */
    readonly overrides?: SpotFleetRequestLaunchTemplateConfigOverrides[];
}
export interface SpotFleetRequestTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class SpotFleetRequest extends TerraformResource {
    constructor(scope: Construct, id: string, config: SpotFleetRequestConfig);
    private _allocationStrategy?;
    get allocationStrategy(): string | undefined;
    set allocationStrategy(value: string | undefined);
    get clientToken(): string;
    private _excessCapacityTerminationPolicy?;
    get excessCapacityTerminationPolicy(): string | undefined;
    set excessCapacityTerminationPolicy(value: string | undefined);
    private _fleetType?;
    get fleetType(): string | undefined;
    set fleetType(value: string | undefined);
    private _iamFleetRole;
    get iamFleetRole(): string;
    set iamFleetRole(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _instanceInterruptionBehaviour?;
    get instanceInterruptionBehaviour(): string | undefined;
    set instanceInterruptionBehaviour(value: string | undefined);
    private _instancePoolsToUseCount?;
    get instancePoolsToUseCount(): number | undefined;
    set instancePoolsToUseCount(value: number | undefined);
    private _loadBalancers?;
    get loadBalancers(): string[] | undefined;
    set loadBalancers(value: string[] | undefined);
    private _replaceUnhealthyInstances?;
    get replaceUnhealthyInstances(): boolean | undefined;
    set replaceUnhealthyInstances(value: boolean | undefined);
    private _spotPrice?;
    get spotPrice(): string | undefined;
    set spotPrice(value: string | undefined);
    get spotRequestState(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _targetCapacity;
    get targetCapacity(): number;
    set targetCapacity(value: number);
    private _targetGroupArns?;
    get targetGroupArns(): string[] | undefined;
    set targetGroupArns(value: string[] | undefined);
    private _terminateInstancesWithExpiration?;
    get terminateInstancesWithExpiration(): boolean | undefined;
    set terminateInstancesWithExpiration(value: boolean | undefined);
    private _validFrom?;
    get validFrom(): string | undefined;
    set validFrom(value: string | undefined);
    private _validUntil?;
    get validUntil(): string | undefined;
    set validUntil(value: string | undefined);
    private _waitForFulfillment?;
    get waitForFulfillment(): boolean | undefined;
    set waitForFulfillment(value: boolean | undefined);
    private _launchSpecification?;
    get launchSpecification(): SpotFleetRequestLaunchSpecification[] | undefined;
    set launchSpecification(value: SpotFleetRequestLaunchSpecification[] | undefined);
    private _launchTemplateConfig?;
    get launchTemplateConfig(): SpotFleetRequestLaunchTemplateConfig[] | undefined;
    set launchTemplateConfig(value: SpotFleetRequestLaunchTemplateConfig[] | undefined);
    private _timeouts?;
    get timeouts(): SpotFleetRequestTimeouts | undefined;
    set timeouts(value: SpotFleetRequestTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
