"use strict";
// https://www.terraform.io/docs/providers/aws/r/spot_fleet_request.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpotFleetRequest = void 0;
const cdktf_1 = require("cdktf");
// Resource
class SpotFleetRequest extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_spot_fleet_request',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._allocationStrategy = config.allocationStrategy;
        this._excessCapacityTerminationPolicy = config.excessCapacityTerminationPolicy;
        this._fleetType = config.fleetType;
        this._iamFleetRole = config.iamFleetRole;
        this._instanceInterruptionBehaviour = config.instanceInterruptionBehaviour;
        this._instancePoolsToUseCount = config.instancePoolsToUseCount;
        this._loadBalancers = config.loadBalancers;
        this._replaceUnhealthyInstances = config.replaceUnhealthyInstances;
        this._spotPrice = config.spotPrice;
        this._tags = config.tags;
        this._targetCapacity = config.targetCapacity;
        this._targetGroupArns = config.targetGroupArns;
        this._terminateInstancesWithExpiration = config.terminateInstancesWithExpiration;
        this._validFrom = config.validFrom;
        this._validUntil = config.validUntil;
        this._waitForFulfillment = config.waitForFulfillment;
        this._launchSpecification = config.launchSpecification;
        this._launchTemplateConfig = config.launchTemplateConfig;
        this._timeouts = config.timeouts;
    }
    get allocationStrategy() {
        return this._allocationStrategy;
    }
    set allocationStrategy(value) {
        this._allocationStrategy = value;
    }
    // client_token - computed: true, optional: false, required: true
    get clientToken() {
        return this.getStringAttribute('client_token');
    }
    get excessCapacityTerminationPolicy() {
        return this._excessCapacityTerminationPolicy;
    }
    set excessCapacityTerminationPolicy(value) {
        this._excessCapacityTerminationPolicy = value;
    }
    get fleetType() {
        return this._fleetType;
    }
    set fleetType(value) {
        this._fleetType = value;
    }
    get iamFleetRole() {
        return this._iamFleetRole;
    }
    set iamFleetRole(value) {
        this._iamFleetRole = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get instanceInterruptionBehaviour() {
        return this._instanceInterruptionBehaviour;
    }
    set instanceInterruptionBehaviour(value) {
        this._instanceInterruptionBehaviour = value;
    }
    get instancePoolsToUseCount() {
        return this._instancePoolsToUseCount;
    }
    set instancePoolsToUseCount(value) {
        this._instancePoolsToUseCount = value;
    }
    get loadBalancers() {
        var _a;
        return (_a = this._loadBalancers) !== null && _a !== void 0 ? _a : this.getListAttribute('load_balancers');
    }
    set loadBalancers(value) {
        this._loadBalancers = value;
    }
    get replaceUnhealthyInstances() {
        return this._replaceUnhealthyInstances;
    }
    set replaceUnhealthyInstances(value) {
        this._replaceUnhealthyInstances = value;
    }
    get spotPrice() {
        return this._spotPrice;
    }
    set spotPrice(value) {
        this._spotPrice = value;
    }
    // spot_request_state - computed: true, optional: false, required: true
    get spotRequestState() {
        return this.getStringAttribute('spot_request_state');
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get targetCapacity() {
        return this._targetCapacity;
    }
    set targetCapacity(value) {
        this._targetCapacity = value;
    }
    get targetGroupArns() {
        var _a;
        return (_a = this._targetGroupArns) !== null && _a !== void 0 ? _a : this.getListAttribute('target_group_arns');
    }
    set targetGroupArns(value) {
        this._targetGroupArns = value;
    }
    get terminateInstancesWithExpiration() {
        return this._terminateInstancesWithExpiration;
    }
    set terminateInstancesWithExpiration(value) {
        this._terminateInstancesWithExpiration = value;
    }
    get validFrom() {
        return this._validFrom;
    }
    set validFrom(value) {
        this._validFrom = value;
    }
    get validUntil() {
        return this._validUntil;
    }
    set validUntil(value) {
        this._validUntil = value;
    }
    get waitForFulfillment() {
        return this._waitForFulfillment;
    }
    set waitForFulfillment(value) {
        this._waitForFulfillment = value;
    }
    get launchSpecification() {
        return this._launchSpecification;
    }
    set launchSpecification(value) {
        this._launchSpecification = value;
    }
    get launchTemplateConfig() {
        return this._launchTemplateConfig;
    }
    set launchTemplateConfig(value) {
        this._launchTemplateConfig = value;
    }
    get timeouts() {
        return this._timeouts;
    }
    set timeouts(value) {
        this._timeouts = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allocation_strategy: this._allocationStrategy,
            excess_capacity_termination_policy: this._excessCapacityTerminationPolicy,
            fleet_type: this._fleetType,
            iam_fleet_role: this._iamFleetRole,
            instance_interruption_behaviour: this._instanceInterruptionBehaviour,
            instance_pools_to_use_count: this._instancePoolsToUseCount,
            load_balancers: this._loadBalancers,
            replace_unhealthy_instances: this._replaceUnhealthyInstances,
            spot_price: this._spotPrice,
            tags: this._tags,
            target_capacity: this._targetCapacity,
            target_group_arns: this._targetGroupArns,
            terminate_instances_with_expiration: this._terminateInstancesWithExpiration,
            valid_from: this._validFrom,
            valid_until: this._validUntil,
            wait_for_fulfillment: this._waitForFulfillment,
            launch_specification: this._launchSpecification,
            launch_template_config: this._launchTemplateConfig,
            timeouts: this._timeouts,
        };
    }
}
exports.SpotFleetRequest = SpotFleetRequest;
//# sourceMappingURL=data:application/json;base64,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