"use strict";
// https://www.terraform.io/docs/providers/aws/r/spot_instance_request.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpotInstanceRequest = void 0;
const cdktf_1 = require("cdktf");
// Resource
class SpotInstanceRequest extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_spot_instance_request',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._ami = config.ami;
        this._associatePublicIpAddress = config.associatePublicIpAddress;
        this._availabilityZone = config.availabilityZone;
        this._blockDurationMinutes = config.blockDurationMinutes;
        this._cpuCoreCount = config.cpuCoreCount;
        this._cpuThreadsPerCore = config.cpuThreadsPerCore;
        this._disableApiTermination = config.disableApiTermination;
        this._ebsOptimized = config.ebsOptimized;
        this._getPasswordData = config.fetchPasswordData;
        this._hibernation = config.hibernation;
        this._hostId = config.hostId;
        this._iamInstanceProfile = config.iamInstanceProfile;
        this._instanceInitiatedShutdownBehavior = config.instanceInitiatedShutdownBehavior;
        this._instanceInterruptionBehaviour = config.instanceInterruptionBehaviour;
        this._instanceType = config.instanceType;
        this._ipv6AddressCount = config.ipv6AddressCount;
        this._ipv6Addresses = config.ipv6Addresses;
        this._keyName = config.keyName;
        this._launchGroup = config.launchGroup;
        this._monitoring = config.monitoring;
        this._placementGroup = config.placementGroup;
        this._privateIp = config.privateIp;
        this._securityGroups = config.securityGroups;
        this._sourceDestCheck = config.sourceDestCheck;
        this._spotPrice = config.spotPrice;
        this._spotType = config.spotType;
        this._subnetId = config.subnetId;
        this._tags = config.tags;
        this._tenancy = config.tenancy;
        this._userData = config.userData;
        this._userDataBase64 = config.userDataBase64;
        this._validFrom = config.validFrom;
        this._validUntil = config.validUntil;
        this._volumeTags = config.volumeTags;
        this._vpcSecurityGroupIds = config.vpcSecurityGroupIds;
        this._waitForFulfillment = config.waitForFulfillment;
        this._creditSpecification = config.creditSpecification;
        this._ebsBlockDevice = config.ebsBlockDevice;
        this._ephemeralBlockDevice = config.ephemeralBlockDevice;
        this._metadataOptions = config.metadataOptions;
        this._networkInterface = config.networkInterface;
        this._rootBlockDevice = config.rootBlockDevice;
        this._timeouts = config.timeouts;
    }
    get ami() {
        return this._ami;
    }
    set ami(value) {
        this._ami = value;
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get associatePublicIpAddress() {
        var _a;
        return (_a = this._associatePublicIpAddress) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('associate_public_ip_address');
    }
    set associatePublicIpAddress(value) {
        this._associatePublicIpAddress = value;
    }
    get availabilityZone() {
        var _a;
        return (_a = this._availabilityZone) !== null && _a !== void 0 ? _a : this.getStringAttribute('availability_zone');
    }
    set availabilityZone(value) {
        this._availabilityZone = value;
    }
    get blockDurationMinutes() {
        return this._blockDurationMinutes;
    }
    set blockDurationMinutes(value) {
        this._blockDurationMinutes = value;
    }
    get cpuCoreCount() {
        var _a;
        return (_a = this._cpuCoreCount) !== null && _a !== void 0 ? _a : this.getNumberAttribute('cpu_core_count');
    }
    set cpuCoreCount(value) {
        this._cpuCoreCount = value;
    }
    get cpuThreadsPerCore() {
        var _a;
        return (_a = this._cpuThreadsPerCore) !== null && _a !== void 0 ? _a : this.getNumberAttribute('cpu_threads_per_core');
    }
    set cpuThreadsPerCore(value) {
        this._cpuThreadsPerCore = value;
    }
    get disableApiTermination() {
        return this._disableApiTermination;
    }
    set disableApiTermination(value) {
        this._disableApiTermination = value;
    }
    get ebsOptimized() {
        return this._ebsOptimized;
    }
    set ebsOptimized(value) {
        this._ebsOptimized = value;
    }
    get fetchPasswordData() {
        return this._getPasswordData;
    }
    set fetchPasswordData(value) {
        this._getPasswordData = value;
    }
    get hibernation() {
        return this._hibernation;
    }
    set hibernation(value) {
        this._hibernation = value;
    }
    get hostId() {
        var _a;
        return (_a = this._hostId) !== null && _a !== void 0 ? _a : this.getStringAttribute('host_id');
    }
    set hostId(value) {
        this._hostId = value;
    }
    get iamInstanceProfile() {
        return this._iamInstanceProfile;
    }
    set iamInstanceProfile(value) {
        this._iamInstanceProfile = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get instanceInitiatedShutdownBehavior() {
        return this._instanceInitiatedShutdownBehavior;
    }
    set instanceInitiatedShutdownBehavior(value) {
        this._instanceInitiatedShutdownBehavior = value;
    }
    get instanceInterruptionBehaviour() {
        return this._instanceInterruptionBehaviour;
    }
    set instanceInterruptionBehaviour(value) {
        this._instanceInterruptionBehaviour = value;
    }
    // instance_state - computed: true, optional: false, required: true
    get instanceState() {
        return this.getStringAttribute('instance_state');
    }
    get instanceType() {
        return this._instanceType;
    }
    set instanceType(value) {
        this._instanceType = value;
    }
    get ipv6AddressCount() {
        var _a;
        return (_a = this._ipv6AddressCount) !== null && _a !== void 0 ? _a : this.getNumberAttribute('ipv6_address_count');
    }
    set ipv6AddressCount(value) {
        this._ipv6AddressCount = value;
    }
    get ipv6Addresses() {
        var _a;
        return (_a = this._ipv6Addresses) !== null && _a !== void 0 ? _a : this.getListAttribute('ipv6_addresses');
    }
    set ipv6Addresses(value) {
        this._ipv6Addresses = value;
    }
    get keyName() {
        var _a;
        return (_a = this._keyName) !== null && _a !== void 0 ? _a : this.getStringAttribute('key_name');
    }
    set keyName(value) {
        this._keyName = value;
    }
    get launchGroup() {
        return this._launchGroup;
    }
    set launchGroup(value) {
        this._launchGroup = value;
    }
    get monitoring() {
        return this._monitoring;
    }
    set monitoring(value) {
        this._monitoring = value;
    }
    // network_interface_id - computed: true, optional: false, required: true
    get networkInterfaceId() {
        return this.getStringAttribute('network_interface_id');
    }
    // outpost_arn - computed: true, optional: false, required: true
    get outpostArn() {
        return this.getStringAttribute('outpost_arn');
    }
    // password_data - computed: true, optional: false, required: true
    get passwordData() {
        return this.getStringAttribute('password_data');
    }
    get placementGroup() {
        var _a;
        return (_a = this._placementGroup) !== null && _a !== void 0 ? _a : this.getStringAttribute('placement_group');
    }
    set placementGroup(value) {
        this._placementGroup = value;
    }
    // primary_network_interface_id - computed: true, optional: false, required: true
    get primaryNetworkInterfaceId() {
        return this.getStringAttribute('primary_network_interface_id');
    }
    // private_dns - computed: true, optional: false, required: true
    get privateDns() {
        return this.getStringAttribute('private_dns');
    }
    get privateIp() {
        var _a;
        return (_a = this._privateIp) !== null && _a !== void 0 ? _a : this.getStringAttribute('private_ip');
    }
    set privateIp(value) {
        this._privateIp = value;
    }
    // public_dns - computed: true, optional: false, required: true
    get publicDns() {
        return this.getStringAttribute('public_dns');
    }
    // public_ip - computed: true, optional: false, required: true
    get publicIp() {
        return this.getStringAttribute('public_ip');
    }
    get securityGroups() {
        var _a;
        return (_a = this._securityGroups) !== null && _a !== void 0 ? _a : this.getListAttribute('security_groups');
    }
    set securityGroups(value) {
        this._securityGroups = value;
    }
    get sourceDestCheck() {
        return this._sourceDestCheck;
    }
    set sourceDestCheck(value) {
        this._sourceDestCheck = value;
    }
    // spot_bid_status - computed: true, optional: false, required: true
    get spotBidStatus() {
        return this.getStringAttribute('spot_bid_status');
    }
    // spot_instance_id - computed: true, optional: false, required: true
    get spotInstanceId() {
        return this.getStringAttribute('spot_instance_id');
    }
    get spotPrice() {
        return this._spotPrice;
    }
    set spotPrice(value) {
        this._spotPrice = value;
    }
    // spot_request_state - computed: true, optional: false, required: true
    get spotRequestState() {
        return this.getStringAttribute('spot_request_state');
    }
    get spotType() {
        return this._spotType;
    }
    set spotType(value) {
        this._spotType = value;
    }
    get subnetId() {
        var _a;
        return (_a = this._subnetId) !== null && _a !== void 0 ? _a : this.getStringAttribute('subnet_id');
    }
    set subnetId(value) {
        this._subnetId = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get tenancy() {
        var _a;
        return (_a = this._tenancy) !== null && _a !== void 0 ? _a : this.getStringAttribute('tenancy');
    }
    set tenancy(value) {
        this._tenancy = value;
    }
    get userData() {
        return this._userData;
    }
    set userData(value) {
        this._userData = value;
    }
    get userDataBase64() {
        return this._userDataBase64;
    }
    set userDataBase64(value) {
        this._userDataBase64 = value;
    }
    get validFrom() {
        var _a;
        return (_a = this._validFrom) !== null && _a !== void 0 ? _a : this.getStringAttribute('valid_from');
    }
    set validFrom(value) {
        this._validFrom = value;
    }
    get validUntil() {
        var _a;
        return (_a = this._validUntil) !== null && _a !== void 0 ? _a : this.getStringAttribute('valid_until');
    }
    set validUntil(value) {
        this._validUntil = value;
    }
    get volumeTags() {
        return this._volumeTags;
    }
    set volumeTags(value) {
        this._volumeTags = value;
    }
    get vpcSecurityGroupIds() {
        var _a;
        return (_a = this._vpcSecurityGroupIds) !== null && _a !== void 0 ? _a : this.getListAttribute('vpc_security_group_ids');
    }
    set vpcSecurityGroupIds(value) {
        this._vpcSecurityGroupIds = value;
    }
    get waitForFulfillment() {
        return this._waitForFulfillment;
    }
    set waitForFulfillment(value) {
        this._waitForFulfillment = value;
    }
    get creditSpecification() {
        return this._creditSpecification;
    }
    set creditSpecification(value) {
        this._creditSpecification = value;
    }
    get ebsBlockDevice() {
        return this._ebsBlockDevice;
    }
    set ebsBlockDevice(value) {
        this._ebsBlockDevice = value;
    }
    get ephemeralBlockDevice() {
        return this._ephemeralBlockDevice;
    }
    set ephemeralBlockDevice(value) {
        this._ephemeralBlockDevice = value;
    }
    get metadataOptions() {
        return this._metadataOptions;
    }
    set metadataOptions(value) {
        this._metadataOptions = value;
    }
    get networkInterface() {
        return this._networkInterface;
    }
    set networkInterface(value) {
        this._networkInterface = value;
    }
    get rootBlockDevice() {
        return this._rootBlockDevice;
    }
    set rootBlockDevice(value) {
        this._rootBlockDevice = value;
    }
    get timeouts() {
        return this._timeouts;
    }
    set timeouts(value) {
        this._timeouts = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            ami: this._ami,
            associate_public_ip_address: this._associatePublicIpAddress,
            availability_zone: this._availabilityZone,
            block_duration_minutes: this._blockDurationMinutes,
            cpu_core_count: this._cpuCoreCount,
            cpu_threads_per_core: this._cpuThreadsPerCore,
            disable_api_termination: this._disableApiTermination,
            ebs_optimized: this._ebsOptimized,
            get_password_data: this._getPasswordData,
            hibernation: this._hibernation,
            host_id: this._hostId,
            iam_instance_profile: this._iamInstanceProfile,
            instance_initiated_shutdown_behavior: this._instanceInitiatedShutdownBehavior,
            instance_interruption_behaviour: this._instanceInterruptionBehaviour,
            instance_type: this._instanceType,
            ipv6_address_count: this._ipv6AddressCount,
            ipv6_addresses: this._ipv6Addresses,
            key_name: this._keyName,
            launch_group: this._launchGroup,
            monitoring: this._monitoring,
            placement_group: this._placementGroup,
            private_ip: this._privateIp,
            security_groups: this._securityGroups,
            source_dest_check: this._sourceDestCheck,
            spot_price: this._spotPrice,
            spot_type: this._spotType,
            subnet_id: this._subnetId,
            tags: this._tags,
            tenancy: this._tenancy,
            user_data: this._userData,
            user_data_base64: this._userDataBase64,
            valid_from: this._validFrom,
            valid_until: this._validUntil,
            volume_tags: this._volumeTags,
            vpc_security_group_ids: this._vpcSecurityGroupIds,
            wait_for_fulfillment: this._waitForFulfillment,
            credit_specification: this._creditSpecification,
            ebs_block_device: this._ebsBlockDevice,
            ephemeral_block_device: this._ephemeralBlockDevice,
            metadata_options: this._metadataOptions,
            network_interface: this._networkInterface,
            root_block_device: this._rootBlockDevice,
            timeouts: this._timeouts,
        };
    }
}
exports.SpotInstanceRequest = SpotInstanceRequest;
//# sourceMappingURL=data:application/json;base64,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