import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SqsQueueConfig extends TerraformMetaArguments {
    readonly contentBasedDeduplication?: boolean;
    readonly delaySeconds?: number;
    readonly fifoQueue?: boolean;
    readonly kmsDataKeyReusePeriodSeconds?: number;
    readonly kmsMasterKeyId?: string;
    readonly maxMessageSize?: number;
    readonly messageRetentionSeconds?: number;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly policy?: string;
    readonly receiveWaitTimeSeconds?: number;
    readonly redrivePolicy?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly visibilityTimeoutSeconds?: number;
}
export declare class SqsQueue extends TerraformResource {
    constructor(scope: Construct, id: string, config?: SqsQueueConfig);
    get arn(): string;
    private _contentBasedDeduplication?;
    get contentBasedDeduplication(): boolean | undefined;
    set contentBasedDeduplication(value: boolean | undefined);
    private _delaySeconds?;
    get delaySeconds(): number | undefined;
    set delaySeconds(value: number | undefined);
    private _fifoQueue?;
    get fifoQueue(): boolean | undefined;
    set fifoQueue(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsDataKeyReusePeriodSeconds?;
    get kmsDataKeyReusePeriodSeconds(): number | undefined;
    set kmsDataKeyReusePeriodSeconds(value: number | undefined);
    private _kmsMasterKeyId?;
    get kmsMasterKeyId(): string | undefined;
    set kmsMasterKeyId(value: string | undefined);
    private _maxMessageSize?;
    get maxMessageSize(): number | undefined;
    set maxMessageSize(value: number | undefined);
    private _messageRetentionSeconds?;
    get messageRetentionSeconds(): number | undefined;
    set messageRetentionSeconds(value: number | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _policy?;
    get policy(): string | undefined;
    set policy(value: string | undefined);
    private _receiveWaitTimeSeconds?;
    get receiveWaitTimeSeconds(): number | undefined;
    set receiveWaitTimeSeconds(value: number | undefined);
    private _redrivePolicy?;
    get redrivePolicy(): string | undefined;
    set redrivePolicy(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _visibilityTimeoutSeconds?;
    get visibilityTimeoutSeconds(): number | undefined;
    set visibilityTimeoutSeconds(value: number | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
